package com.pushpole.sdk.service;

import android.app.IntentService;
import android.content.Intent;
import android.os.IBinder;

import androidx.annotation.Nullable;

import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.DetectedActivity;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 2017-02-19, 2:14 PM.
 *
 * @author Akram Shokri
 *
 * Obtain current user activity
 */

public class PushPoleActivityService extends IntentService {

    public PushPoleActivityService() {
        super("PushPoleActivityService");
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        try {
            if (ActivityRecognitionResult.hasResult(intent)) {
                boolean sendAll = intent.getBooleanExtra(Constants.getVal(Constants.SEND_ALL_DETECTED_ACTIVITIES), false);
                ActivityRecognitionResult result = ActivityRecognitionResult.extractResult(intent);

                List<DetectedActivity> activities = result.getProbableActivities();
                if (sendAll) { //called from DetectUserActivityTask
                    ListPack lp = handleDetectedActivities(activities, result.getTime());
                    SendManager.getInstance(getApplicationContext()).send(Constants.getVal(Constants.DETECTED_ACTIVITY_T), lp);
                } else { //called from FloatingTask
                    DetectedActivity mostProbable;
                    if (result.getMostProbableActivity().getType() != DetectedActivity.UNKNOWN) {
                        mostProbable = result.getMostProbableActivity();
                    } else {
                        Collections.sort(activities, new Comparator<DetectedActivity>() {
                            @Override
                            public int compare(DetectedActivity var1, DetectedActivity var2) {
                                int var3 = Integer.valueOf(var2.getConfidence()).compareTo(Integer.valueOf(var1.getConfidence()));
                                return var3 == 0?Integer.valueOf(var1.getType()).compareTo(Integer.valueOf(var2.getType())):var3;
                            }
                        });
                        mostProbable = (activities.size() > 1) ? activities.get(1) : activities.get(0);
                    }
                    KeyStore.getInstance(getApplicationContext()).putString(Constants.getVal(Constants.MOST_PROBABLE_USER_ACTIVITY),
                            nameOfUserActivity(mostProbable.getType()) + "_" +
                                    mostProbable.getConfidence());
                }

            }
        }catch (Exception e){}

    }

    private ListPack handleDetectedActivities(List<DetectedActivity> probableActivities, long detectionTime) {
        ListPack allActivities = new ListPack();

        for( DetectedActivity activity : probableActivities ) {
            Pack activityPack = new Pack();
            activityPack.putInt(Constants.getVal(Constants.ACTIVITY_CONFIDENCE),  activity.getConfidence());
            activityPack.putString(Constants.getVal(Constants.ACTIVITY_TYPE), nameOfUserActivity(activity.getType()));
            activityPack.putLong(Constants.getVal(Constants.TIMESTAMP), detectionTime);
            allActivities.addPack(activityPack);
        }
        return allActivities;
    }

    private String nameOfUserActivity(int type) {
        switch( type) {
            case DetectedActivity.IN_VEHICLE: {
                return "vehicle";
            }
            case DetectedActivity.ON_BICYCLE: {
                return "bicycle";
            }
            case DetectedActivity.ON_FOOT: {
                return "foot";
            }
            case DetectedActivity.RUNNING: {
                return "running";
            }
            case DetectedActivity.STILL: {
                return "still";
            }
            case DetectedActivity.TILTING: {
                return"tilt";
            }
            case DetectedActivity.WALKING: {
                return "walking";
            }
            case DetectedActivity.UNKNOWN: {
                return"unknown";
            }
            default:
                return"unknown";
        }
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return super.onBind(intent);
    }
}
