package com.pushpole.sdk.message.upstream;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PushPoleInfo;
import com.pushpole.sdk.SenderInfo;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.device.DeviceApplicationHelper;
import com.pushpole.sdk.device.DeviceIDHelper;
import com.pushpole.sdk.device.DeviceInfoHelper;
import com.pushpole.sdk.device.DeviceMedia;
import com.pushpole.sdk.device.DevicePlatform;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.util.Pack;

import static com.pushpole.sdk.Constants.Info.F_GCM_TOKEN;

/**
 * A class that represent upstream message for registering client in pushpole-server
 * the message contains clients device data, GCM token and app token
 */

public class RegisterUpstreamMessage extends UpstreamMessage {
    private String mDeviceId;
    private String mAndroidId;
    private DeviceMedia mDeviceMedia;
    private DevicePlatform mDevicePlatform;
    private String mOSVersion;
    private String mDeviceBrand;
    private String mDeviceModel;
    private String mScreenSize;
    private String mOperator;
    private String mInstallerPackageName;
    private String mGcmToken;
    private String mAppVersion;
    private int mAppVersionCode;
    private String mPushPoleVersion;
    private int mPushPoleVersionCode;
    private String mGooglePlayServicesVersion;
    private String mRegisterCause;

    /***
     * store {@link RegisterUpstreamMessage} data in to a {@link Pack} object
     *
     * @return the {@link Pack} object
     */
    @Override
    public Pack toPack() {
        Pack pack = super.toPack();
        pack.putString(Constants.getVal(Constants.Info.F_DEVICE_ID), mDeviceId);
        pack.putString(Constants.getVal(Constants.Info.F_DEVICE_BRAND), mDeviceBrand);
        pack.putString(Constants.getVal(Constants.Info.F_DEVICE_MODEL), mDeviceModel);
        pack.putString(Constants.getVal(Constants.Info.F_OS_VERSION), mOSVersion);
        /*pack.putString(F_ANDROID_ID, mAndroidId);
        pack.putString(F_DEVICE_MEDIA, mDeviceMedia.getCode());
        pack.putString(F_DEVICE_PLATFORM, mDevicePlatform.getCode());
        pack.putString(F_SCREEN_SIZE, mScreenSize);
        if (mOperator != null) {
            pack.putString(F_OPERATOR, mOperator);
        }
        if (mInstallerPackageName != null) {
            pack.putString(F_INSTALLER, mInstallerPackageName);
        } else {
            pack.putString(F_INSTALLER, F_INSTALLER_NAME_DIRECT);
        }*/

        pack.putString(Constants.getVal(F_GCM_TOKEN), mGcmToken);

        pack.putString(Constants.getVal(Constants.Info.F_APP_VERSION_CODE), String.valueOf(mAppVersionCode));
        pack.putString(Constants.getVal(Constants.Info.F_APP_VERSION), mAppVersion);


        pack.putString(Constants.getVal(Constants.Info.F_PUSHPOLE_VERSION), mPushPoleVersion
        );
        pack.putInt(Constants.getVal(Constants.Info.F_PUSHPOLE_VERSION_CODE), mPushPoleVersionCode);
        /*pack.putString(F_GOOGLE_PLAY_SERVICES_VERSION, mGooglePlayServicesVersion);*/
        pack.putString(Constants.getVal(Constants.REGISTER_CAUSE), mRegisterCause);

        return pack;
    }

    /***
     * return message type
     *
     * @return {@code Type.REGISTER}
     */
    @Override
    public UpstreamMessage.Type getMessageType() {
        return Type.REGISTER;
    }

    /***
     * Factory class for generating {@link RegisterUpstreamMessage} instance
     */
    public static class Factory extends UpstreamMessageFactory {

        /***
         * generate {@link RegisterUpstreamMessage} instance
         *
         * @param data the pack that contains data for populating message
         * @return {@link RegisterUpstreamMessage} instance
         */
        @Override
        public UpstreamMessage buildMessage(Pack data) {
            RegisterUpstreamMessage message = new RegisterUpstreamMessage();
            populateMessage(message, data);

            message.mDeviceId = data.getString(Constants.getVal(Constants.Info.F_DEVICE_ID));
            message.mDeviceBrand = data.getString(Constants.getVal(Constants.Info.F_DEVICE_BRAND));
            message.mDeviceModel = data.getString(Constants.getVal(Constants.Info.F_DEVICE_MODEL));
            message.mAppVersion = data.getString(Constants.getVal(Constants.Info.F_APP_VERSION));
            try {
                message.mAppVersionCode = Integer.parseInt(data.getString(
                        Constants.getVal(Constants.Info.F_APP_VERSION_CODE))
                );
            } catch (NumberFormatException e) {
                Logger.warning("Invalid value for app version code: ",
                        data.getString(Constants.getVal(Constants.Info.F_APP_VERSION_CODE)));
            }

            message.mOSVersion = data.getString(Constants.getVal(Constants.Info.F_OS_VERSION));
           /* message.mAndroidId = data.getString(F_ANDROID_ID);
            message.mDevicePlatform = DevicePlatform.fromCode(data.getString(F_DEVICE_PLATFORM));
            message.mDeviceMedia = DeviceMedia.fromCode(data.getString(F_DEVICE_MEDIA));
            message.mScreenSize = data.getString(F_SCREEN_SIZE);
            message.mOperator = data.getString(F_OPERATOR);
            message.mInstallerPackageName = data.getString(F_INSTALLER);*/
            message.mGcmToken = data.getString(Constants.getVal(F_GCM_TOKEN));
            /*message.mGooglePlayServicesVersion = data.getString(F_GOOGLE_PLAY_SERVICES_VERSION);
            message.mAppVersion = data.getString(F_APP_VERSION);

            try {
                message.mAppVersionCode = Integer.parseInt(data.getString(F_APP_VERSION_CODE));
            } catch (NumberFormatException e) {
                Logger.warning("Invalid value for app version code: ", data.getString(F_APP_VERSION_CODE));
            }
*/
            message.mPushPoleVersion = data.getString(Constants.getVal(Constants.Info.F_PUSHPOLE_VERSION));

            try {
                message.mPushPoleVersionCode = data.getInt(Constants.getVal(Constants.Info.F_PUSHPOLE_VERSION_CODE));
            } catch (Exception e) {
                Logger.warning("Invalid value for pushpole version code: ",
                        data.getString(Constants.getVal(Constants.Info.F_PUSHPOLE_VERSION_CODE)));
            }

            return message;
        }

        /***
         * generate {@link RegisterUpstreamMessage} instance
         *
         * @param context                 the app context
         * @param deviceIdHelper          the device ID helper
         * @param deviceInfoHelper        the device info helper
         * @param deviceApplicationHelper the device application helper
         * @return {@link RegisterUpstreamMessage} instance
         */
        public RegisterUpstreamMessage buildUpstreamMessage(Context context, DeviceIDHelper deviceIdHelper,
                                                            DeviceInfoHelper deviceInfoHelper, DeviceApplicationHelper deviceApplicationHelper) {
            RegisterUpstreamMessage message = new RegisterUpstreamMessage();
            //populateMessage(message);

            message.mDeviceId = deviceIdHelper.getDeviceId();
            message.mOSVersion = deviceInfoHelper.getOSVersion();

            message.mDeviceMedia = deviceInfoHelper.getDeviceMedia();
            message.mDevicePlatform = deviceInfoHelper.getDevicePlatform();
            message.mDeviceModel = deviceInfoHelper.getDeviceModel();
            message.mDeviceBrand = deviceInfoHelper.getDeviceBrand();

          /*
            Point screenSize = deviceInfoHelper.getScreenSize();
            message.mScreenSize = String.format("%dx%d", screenSize.x, screenSize.y);
            message.mOperator = NetworkHelper.getOperatorName(context);
            message.mAndroidId = deviceIdHelper.getAndroidId();
            message.mInstallerPackageName = deviceApplicationHelper.getInstallerPackageName();
            */

            message.mGcmToken = SenderInfo.getInstance(context).getToken();

            PackageInfo pInfo = null;
            try {
                pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                message.mAppVersion = pInfo.versionName;
                message.mAppVersionCode = pInfo.versionCode;
            } catch (PackageManager.NameNotFoundException e) {
                Logger.warning("Getting application version failed");
            }

            message.mPushPoleVersion = PushPoleInfo.VERSION_NAME;
            message.mPushPoleVersionCode = PushPoleInfo.VERSION_CODE;
            /*
            message.mGooglePlayServicesVersion = GooglePlayServicesHelper.getGooglePlayServicesVersionName(context);
            */
            //RegisterCause is only needed in register to server upstream stanza
            message.mRegisterCause = KeyStore.getInstance(context)
                    .getString(Constants.getVal(Constants.REGISTER_CAUSE),
                            Constants.getVal(Constants.RegisterCause.INITIALIZE));
            return message;
        }

        /***
         * generate {@link RegisterUpstreamMessage} instance
         *
         * @param context the app context
         * @return
         */
        public RegisterUpstreamMessage buildUpstreamMessage(Context context) {
            DeviceIDHelper deviceIdHelper = new DeviceIDHelper(context);
            DeviceInfoHelper deviceInfoHelper = new DeviceInfoHelper(context);
            DeviceApplicationHelper deviceApplicationHelper = new DeviceApplicationHelper(context);
            return buildUpstreamMessage(context, deviceIdHelper, deviceInfoHelper, deviceApplicationHelper);
        }
    }
}
