package com.pushpole.sdk.message;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.upstream.UpstreamMessage;
import com.pushpole.sdk.util.Pack;

/***
 * A class for making ack message
 */
public class ResponseMessage extends Message {
    private final static int MISSING_STATUS = -1;
    private final static int INVALID_STATUS = -2;

    private int mStatus;
    private String mError;
    private UpstreamMessage.Type mMessageType;

    public int getStatus() {
        return mStatus;
    }

    public void setStatus(int status) {
        mStatus = status;
    }

    public String getError() {
        return mError;
    }

    public void setError(String error) {
        mError = error;
    }

    public UpstreamMessage.Type getMessageType() {
        return mMessageType;
    }

    public void setMessageType(UpstreamMessage.Type messageType) {
        mMessageType = messageType;
    }

    @Override
    public MessageDirection getMessageDirection() {
        return MessageDirection.DOWNSTREAM;
    }

    public static class Factory {
        public ResponseMessage buildResponse(Pack data) {
            ResponseMessage message = new ResponseMessage();

            message.setMessageId(data.getString(Constants.getVal(Constants.F_MESSAGE_ID), null));

            String statusStr = data.getString(Constants.getVal(Constants.F_STATUS), null);
            if (statusStr == null) {
                statusStr = String.valueOf(MISSING_STATUS);
                Logger.error(null, "Missing status in response", new LogData(
                        "Message ID", message.getMessageId()
                ));
            }

            try {
                message.setStatus(Integer.parseInt(statusStr));
            } catch (NumberFormatException e) {
                Logger.error(null, "Invalid status in response", new LogData(
                        "Status", statusStr,
                        "Message ID", message.getMessageId()
                ));
                message.setStatus(INVALID_STATUS);
            }

            message.setError(data.getString(Constants.getVal(Constants.F_ERROR)));


            int messageTypeCode = 0;
            try {
                messageTypeCode = Integer.parseInt(data.getString(Constants.getVal(Constants.F_MESSAGE_TYPE)));
            } catch (NumberFormatException e) {
                Logger.warning(null, "Invalid Message Type for Response message: %s",
                        data.getString(Constants.getVal(Constants.F_MESSAGE_TYPE)));
                return null;
            }

            UpstreamMessage.Type messageType = UpstreamMessage.Type.fromCode(messageTypeCode);
            if (messageType == null) {
                Logger.warning(null, "Response received for invalid message type", new LogData(
                        "Message Type", data.getString(Constants.getVal(Constants.F_MESSAGE_TYPE))
                ));
                return null;
            }

            message.setMessageType(messageType);


            return message;
        }
    }
}
