package com.pushpole.sdk.device;

import java.util.HashMap;
import java.util.Map;

/**
 * Device media types
 *
 * @author Hadi Zolfaghari
 * @since 1.0.0
 */
public enum DeviceMedia {
    PHONE("P"),
    TABLET("T"),
    BROWSER("B");

    private static Map<String, DeviceMedia> mValueMap;

    static {
        mValueMap = new HashMap<>();
        for (DeviceMedia value : DeviceMedia.values()) {
            mValueMap.put(value.getCode(), value);
        }
    }

    private String mCode;

    /**
     * Constructs a DeviceMedia type
     *
     * @param code the unique code string to identify the {@code DeviceMedia} with
     */
    DeviceMedia(String code) {
        mCode = code;
    }

    /**
     * Gets a {@code DeviceMedia} from its code String.
     *
     * @param code the {@code DeviceMedia} code String.
     * @return the {@code DeviceMedia} relating to the given code.
     */
    public static DeviceMedia fromCode(String code) {
        return mValueMap.get(code);
    }

    /**
     * @return the unique code string which identifies the {@code DeviceMedia}
     */
    public String getCode() {
        return mCode;
    }
}
