package com.pushpole.sdk.controller.controllers;

import android.content.Context;
import android.location.Location;
import android.net.wifi.WifiInfo;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.location.GeoManager;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.message.upstream.UpstreamMessageFactory;
import com.pushpole.sdk.network.UpstreamSender;
import com.pushpole.sdk.task.PushPoleAsyncTask;
import com.pushpole.sdk.task.TaskManager;
import com.pushpole.sdk.util.InsufficientPermissionsException;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.NetworkHelper;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-07-05, 1:14 PM.
 * This class respond to Floating Data downstream command, when send and collection type is immediate
 *
 * @author Akram Shokri
 */
public class FloatingDeviceDataController implements DownstreamApiController {
    private Context mContext;

    public FloatingDeviceDataController(Context mContext) {
        this.mContext = mContext;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        Logger.info("Floating request downstream message");
        sendFloatingData();
    }

    public Pack getFloatingData() {
        //get user activity


        synchronized (this) {
            try {
                if ((GeoManager.getInstance(mContext).isLocationEnabled() || GeoManager.getInstance(mContext).isLocationTurnedOn())
                        && !GeoManager.getInstance(mContext).hasGoodLocation()) {
                    GeoManager.getInstance(mContext).requestLocation();
                    wait(5000); //wait to requestLocation done
                }
            } catch (InsufficientPermissionsException e) {
            } catch (InterruptedException e) {
            }
        }

        Location location = null;
        try {
            location = GeoManager.getInstance(mContext).getLocation();
        }
        catch (InsufficientPermissionsException e){}

        Pack devicePack = new Pack();

        if (location != null) {
            devicePack.putString(Constants.getVal(Constants.F_LATITUDE), String.valueOf(location.getLatitude()));
            devicePack.putString(Constants.getVal(Constants.F_LONGITUDE), String.valueOf(location.getLongitude()));
        } else {
            devicePack.putString(Constants.getVal(Constants.F_LATITUDE), "0");
            devicePack.putString(Constants.getVal(Constants.F_LONGITUDE), "0");
        }

        NetworkHelper.PublicIpInfo info = NetworkHelper.getPublicIpAddressInfo();
        if (info != null) {
            devicePack.putString(Constants.getVal(Constants.F_IP_ADDRESS), info.ip);
        } else {
            Logger.warning("Getting public ip info failed");
        }

        //set user activity

        String userActivity= KeyStore.getInstance(mContext).getString(
                Constants.getVal(Constants.MOST_PROBABLE_USER_ACTIVITY), ""
        );
        KeyStore.getInstance(mContext).delete(Constants.getVal(Constants.MOST_PROBABLE_USER_ACTIVITY));
        String [] tmp = userActivity.split("_");
        if(tmp.length == 2){
            devicePack.putString(Constants.getVal(Constants.ACTIVITY_TYPE), tmp[0]);
            try {
                devicePack.putInt(Constants.getVal(Constants.ACTIVITY_CONFIDENCE), Integer.valueOf(tmp[1]));
            }catch (Exception e){}
        }


        String networkTypeName = "none";

        try {
            networkTypeName = NetworkHelper.getNetworkTypeName(mContext);

        } catch (InsufficientPermissionsException e) {
        }
        if (Constants.getVal(Constants.WIFI).equals(networkTypeName)) {
            devicePack.putString(Constants.getVal(Constants.F_TYPE), Constants.getVal(Constants.WIFI));
            WifiInfo wifiInfo = NetworkHelper.WifiNetwork.connectedNetworkStat(mContext);
            if(wifiInfo != null) {
                devicePack.putString(Constants.getVal(Constants.F_WIFI_MAC), wifiInfo.getBSSID());
                String wifiName = wifiInfo.getSSID();
                if(wifiName.startsWith("\""))
                    wifiName = wifiName.substring(1);
                if(wifiName.endsWith("\""))
                    wifiName = wifiName.substring(0, wifiName.length()-1);
                devicePack.putString(Constants.getVal(Constants.F_WIFI_SSID), wifiName);
                devicePack.putInt(Constants.getVal(Constants.F_WIFI_SIGNAL), wifiInfo.getRssi());
            }
        } else if (!Constants.getVal(Constants.NONE).equals(networkTypeName)) {//networkType name contains name of mobile network
            devicePack.putString(Constants.getVal(Constants.F_TYPE), Constants.getVal(Constants.MOBILE));
            devicePack.putString(Constants.getVal(Constants.F_MOBILE_NETWORK_NAME), networkTypeName);
        }

        devicePack.putString(Constants.getVal(Constants.TIMESTAMP), String.valueOf(System.currentTimeMillis()));
        return devicePack;
    }

    private void sendFloatingData() {
        Pack floatingData = this.getFloatingData();
        ListPack listPack = new ListPack();
        listPack.addPack(floatingData);
        final Pack upstreamPack = new Pack();
        upstreamPack.putListPack(Constants.getVal(Constants.FLOATING_DATA_T), listPack);
        upstreamPack.putString(Constants.getVal(Constants.F_MESSAGE_ID), UpstreamMessageFactory.generateMsgId());
        TaskManager.getInstance(mContext).asyncTask(new PushPoleAsyncTask() {
            @Override
            public void run(Context context) {
                new UpstreamSender(context).sendMessage(upstreamPack);
            }
        });
    }


}
