package com.pushpole.sdk.collection.tasks;

import android.content.Context;

import androidx.annotation.NonNull;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.controller.controllers.FloatingDeviceDataController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.options.DefaultOptions;
import com.pushpole.sdk.task.options.SingletonTask;
import com.pushpole.sdk.util.Pack;

/**
 * Created by vahid on 7/16/16.
 */
@SingletonTask
@DefaultOptions(period = 6 * 60 * 60 * 1000) //default schedule: 6 hours
public class FloatingTask extends CollectionTask {
    /**
     * Provides the entry point to Google Play services.
     */

    @NonNull
    @Override
    public Result runTask(Context context, Pack taskData) {
        Logger.info("Running floating data task");
        if (taskData == null || !taskData.getBool("force")) {

            Long collectionPeriod = KeyStore.getInstance(context).getLong("collection_period_t5", 6 * 60 * 60 * 1000L);
            Long lastCollectionTime = KeyStore.getInstance(context).getLong("last_collection_t5", 0);

            if (collectionPeriod == -1) {
                Logger.warning("Skipping floating data collection, the collection has been cancelled and should not run");
                return Result.SUCCESS;
            } else {
                Long now = System.currentTimeMillis();
                if (lastCollectionTime > 0 && now > lastCollectionTime && (now - lastCollectionTime) < collectionPeriod) {
                    Logger.warning("Skipping floating data collection since it has already been run in this interval", new LogData(
                            "Last Run", String.valueOf(lastCollectionTime),
                            "Now", String.valueOf(now),
                            "Period", String.valueOf(collectionPeriod)
                    ));
                    return Result.SUCCESS;
                }
                KeyStore.getInstance(context).putLong("last_collection_t5", now);
            }
        }

        Pack floatingData = new FloatingDeviceDataController(context).getFloatingData();
        this.processResult(context, floatingData, Constants.getVal(Constants.FLOATING_DATA_T));
        return Result.SUCCESS;
    }


}
