package com.pushpole.sdk.util;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collection;

/***
 * a class to create a generic List of objects
 */
public class ListPack extends ArrayList<Object> {
    public ListPack() {
    }

    public ListPack(Collection<String> collection) {
        super(collection);
    }

    public static ListPack fromJson(String jsonStr) throws InvalidJsonException {
        try {
            JSONArray jsonArray = new JSONArray(jsonStr);
            return fromJsonArray(jsonArray);
        } catch (JSONException | NullPointerException e) {
            throw new InvalidJsonException(e);
        }
    }

    public static ListPack fromJsonArray(JSONArray array) throws InvalidJsonException {
        try {
            ListPack listPack = new ListPack();
            for (int i = 0; i < array.length(); i++) {
                Object value = array.get(i);

                if (value instanceof JSONObject) {
                    listPack.addPack(Pack.fromJsonObject((JSONObject) value));
                } else if (value instanceof JSONArray) {
                    listPack.addListPack(ListPack.fromJsonArray((JSONArray) value));
                } else {
                    listPack.add(value);
                }
            }
            return listPack;
        } catch (JSONException | NullPointerException e) {
            throw new InvalidJsonException(e);
        }
    }

    public void addString(int index, String value) {
        add(index, value);
    }

    public void addString(String value) {
        add(value);
    }

    public void addInt(int index, int value) {
        add(index, value);
    }

    public void addInt(int value) {
        add(value);
    }

    public void addBool(int index, boolean bool) {
        add(index, bool);
    }

    public void addBool(boolean bool) {
        add(bool);
    }

    public void addPack(int index, Pack pack) {
        add(index, pack);
    }

    public void addPack(Pack pack) {
        add(pack);
    }

    public void addListPack(int index, ListPack listPack) {
        add(index, listPack);
    }

    public void addListPack(ListPack listPack) {
        add(listPack);
    }

    public String getString(int index) {
        return String.valueOf(get(index));
    }

    public int getInt(int index) {
        return (Integer) get(index);
    }

    public boolean getBool(int index) {
        return (Boolean) get(index);
    }

    public Pack getPack(int index) {
        return (Pack) get(index);
    }

    public ListPack getListPack(int index) {
        return (ListPack) get(index);
    }

    public String toJson() {
        return toJsonArray().toString();
    }

    public JSONArray toJsonArray() {
        JSONArray array = new JSONArray();
        for (int i = 0; i < size(); i++) {
            Object el = get(i);

            if (el instanceof ListPack) {
                array.put(((ListPack) el).toJsonArray());
            } else if (el instanceof Pack) {
                array.put(((Pack) el).toJsonObject());
            } else {
                array.put(el);
            }
        }

        return array;
    }
}
