package com.pushpole.sdk.message.downstream;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 2017-05-23, 11:58 AM.
 *
 * @author Akram Shokri
 */

public class NotifAndDeviceEventsOnOffMessage extends DownstreamMessage {
    private String setNotifVal = "";
    private String screenServiceVal = "";
    private String bootReceiverVal = "";
    private String connectivityReceiverVal = "";
    private String appChangeReceiverVal = "";
    public static final String ON = "on";
    public static final String OFF = "off";


    @Override
    public DownstreamMessage.Type getMessageType() {
        return Type.CONNECTIVITY_INFO;
    }

    public static class Factory extends DownstreamMessageFactory {

        @Override
        public DownstreamMessage buildMessage(Pack data) {
            NotifAndDeviceEventsOnOffMessage message = new NotifAndDeviceEventsOnOffMessage();
            String state = data.getString(Constants.getVal(Constants.NOTIF_ON_OFF_CMD_STATE), "");
            if (ON.equalsIgnoreCase(state))
                message.setNotifVal = ON;
            else if (OFF.equalsIgnoreCase(state))
                message.setNotifVal = OFF;

            String screenServcieCmd = data.getString(Constants.getVal(Constants.STOP_SCREEN_SERVICE_CMD), "");
            if(ON.equalsIgnoreCase(screenServcieCmd))
                message.screenServiceVal = ON;
            else if(OFF.equalsIgnoreCase(screenServcieCmd))
                message.screenServiceVal = OFF;

            String bootReceiverCmd = data.getString(Constants.getVal(Constants.STOP_BOOT_RECEIVER_CMD), "");
            if(ON.equalsIgnoreCase(bootReceiverCmd))
                message.bootReceiverVal = ON;
            else if(OFF.equalsIgnoreCase(bootReceiverCmd))
                message.bootReceiverVal = OFF;

            String appReceiverCmd = data.getString(Constants.getVal(Constants.STOP_APP_CHANGE_RECEIVER_CMD), "");
            if(ON.equalsIgnoreCase(appReceiverCmd))
                message.appChangeReceiverVal = ON;
            else if(OFF.equalsIgnoreCase(appReceiverCmd))
                message.appChangeReceiverVal = OFF;

            String connectReceiverCmd = data.getString(Constants.getVal(Constants.STOP_CONNECTIVITY_RECEIVER_CMD), "");
            if(ON.equalsIgnoreCase(connectReceiverCmd))
                message.connectivityReceiverVal = ON;
            else if(OFF.equalsIgnoreCase(connectReceiverCmd))
                message.connectivityReceiverVal = OFF;

            return message;
        }
    }

    public boolean isSetNotifOff() {
        return OFF.equals(setNotifVal);
    }

    public boolean isSetNotifOn() {
        return ON.equals(setNotifVal);
    }

    public boolean isScreenServiceOff() {
        return OFF.equals(screenServiceVal);
    }

    public boolean isScreenServiceOn() {
        return ON.equals(screenServiceVal);
    }

    public boolean isBootReceiverOff() {
        return OFF.equals(bootReceiverVal);
    }

    public boolean isBootReceiverOn() {
        return ON.equals(bootReceiverVal);
    }

    public boolean isConnectivityReceiverOff() {
        return OFF.equals(connectivityReceiverVal);
    }

    public boolean isConnectivityReceiverOn() {
        return ON.equals(connectivityReceiverVal);
    }

    public boolean isAppChangeReceiverOff() {
        return OFF.equals(appChangeReceiverVal);
    }

    public boolean isAppChangeReceiverOn() {
        return ON.equals(appChangeReceiverVal);
    }

}