package com.pushpole.sdk.fcm;

import android.content.Context;

import com.google.firebase.messaging.RemoteMessage;

import java.util.Map;

import com.pushpole.sdk.controller.controllers.RegisterController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.ExceptionCatcher;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.network.GcmHandler;

public class FcmHandlerImpl {
    public static final String FCM_TOKEN_KEY = "fcm_token";
    private Context mContext;
    private GcmHandler mGcmHandler;


    public FcmHandlerImpl(Context context) {
        mContext = context;
        mGcmHandler = new GcmHandler(context);
    }

    public void onNewToken(String token) {
        try {
            ExceptionCatcher.makePushPoleDefaultExceptionCatcher(mContext);
            Logger.initialize(mContext);
            Logger.info("FireBase token received", new LogData(
                    "Token", token
            ));

            // Save the token in the storage for future usages
            KeyStore.getInstance(mContext).putString(FCM_TOKEN_KEY, token);

            RegisterController controller = new RegisterController(mContext);
            controller.register();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean onMessageReceived(RemoteMessage remoteMessage) {
        boolean courierIsPushPole = false;
        try {
            ExceptionCatcher.makePushPoleDefaultExceptionCatcher(mContext);
            Logger.initialize(mContext);
            Map<String, String> data = remoteMessage.getData();
            courierIsPushPole = data != null && ("pushpole".equals(data.get("courier")) || "pushe".equals(data.get("courier")));
            if (courierIsPushPole) {
                mGcmHandler.onMessageReceived(remoteMessage.getFrom(), remoteMessage.getData());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return courierIsPushPole;
    }

    public void onDeletedMessages() {
        try {
            Logger.initialize(mContext);
            ExceptionCatcher.makePushPoleDefaultExceptionCatcher(mContext);
            mGcmHandler.onDeletedMessages();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onMessageSent(String msgId) {
        try {
            Logger.initialize(mContext);
            ExceptionCatcher.makePushPoleDefaultExceptionCatcher(mContext);
            mGcmHandler.onMessageSent(msgId);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onSendError(String msgId, Exception error) {
        try {
            Logger.initialize(mContext);
            ExceptionCatcher.makePushPoleDefaultExceptionCatcher(mContext);
            mGcmHandler.onSendError(msgId, error.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
