package com.pushpole.sdk;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.pushpole.sdk.util.Crypto;

/***
 * A class that contains Constants of pushpole service
 */
public class Constants {
    public final static String GCM_SERVER = "gcm.googleapis.com";

    public final static List<Map.Entry<String, String>> PUBLIC_IP_API = new ArrayList<>();


    public final static String F_FORCE_PUBLISH = "y\u0082\u0085vxr\u0083\u0088u\u007F|\u0086{";//"force_publish"; //to bypass setNotificationOff if user had set it

    public final static String ACTION_PUSHPOLE_RECEIVE =
            "v\u0082A\u0085\u0082\u0081t\u0086{A\u0083\u0088\u0086{xAeXVX\\iX";//"com.pushe.sdk.RECEIVE";
    public final static String ACTION_RUN_TASK =
            "v\u0082A\u0085\u0082\u0081t\u0086{A\u0083\u0088\u0086{xAehargTf^";//"com.pushe.sdk.RUN_TASK";
    public final static String ACTION_GCM_REGISTER =
            "v\u0082\u0080Az\u0082\u0082z\u007FxAt\u0081w\u0085\u0082|wAvEw\u0080A|\u0081\u0087x\u0081\u0087AeXZ\\fgeTg\\ba";//"com.google.android.c2dm.intent.REGISTRATION";
    public final static String ACTION_GCM_RECEIVE =
            "v\u0082\u0080Az\u0082\u0082z\u007FxAt\u0081w\u0085\u0082|wAvEw\u0080A|\u0081\u0087x\u0081\u0087AeXVX\\iX";//"com.google.android.c2dm.intent.RECEIVE";
    public final static String ACTION_OPEN_DIALOG =
            "v\u0082A\u0085\u0082\u0081t\u0086{A\u0083\u0088\u0086{xAbcXarW\\T_bZ";//"com.pushe.sdk.OPEN_DIALOG";
    public final static String ACTION_SHOW_WEBVIEW =
            "v\u0082A\u0085\u0082\u0081t\u0086{A\u0083\u0088\u0086{xAf[bjrjXUi\\Xj";//"com.pushe.sdk.SHOW_WEBVIEW";
    public final static int OPEN_APP_RATE = 1000 * 60 * 15;
    //public final static String NOTIFICATION_SOUND_RESOURCE_PREFIX = "notification_sound_";

    public final static String MESSAGE_ID = "\u0080x\u0086\u0086tzxr|w";//"message_id";
    public final static String MESSAGE_DIRECTION = "\u0080x\u0086\u0086tzxrw|\u0085xv\u0087|\u0082\u0081";//"message_direction";
    public final static String F_INSTANCE_ID = "|\u0081\u0086\u0087t\u0081vxr|w";//"instance_id";
    public final static String F_MESSAGE_ID = "\u0080x\u0086\u0086tzxr|w";//"message_id";
    public final static String NOTIFICATION_ID = "\u0081\u0082\u0087|y|vt\u0087|\u0082\u0081r|w";//"notification_id";
    private final static String F_TIMESTAMP = "\u0087|\u0080x\u0086\u0087t\u0080\u0083"; //"timestamp";
    public final static String F_LATITUDE = "\u007Ft\u0087"; //"lat";
    public final static String F_LONGITUDE = "\u007F\u0082\u0081z"; //"long";
    public final static String F_STATUS = "\u0086\u0087t\u0087\u0088\u0086"; //"status";
    public final static String F_ERROR = "x\u0085\u0085\u0082\u0085"; //"error";
    public final static String F_MESSAGE_TYPE = "\u0087\u008C\u0083x"; //"type";
    public final static String TOPICS = "\u0087\u0082\u0083|v\u0086";//"topics";
    public final static String RETRY_COUNT = "\u0085x\u0087\u0085\u008Crv\u0082\u0088\u0081\u0087";//"retry_count";

    public final static String F_SOUND_URL = "\u0086\u0082\u0088\u0081wr\u0088\u0085\u007F"; //"sound_url";//key for sound url on ronash-rebrth server
    public final static int F_SOUND_DURATION = 4; //play sound for 5 seconds
    public final static String F_BUTTON_CONTENT = "u\u0087\u0081rv\u0082\u0081\u0087x\u0081\u0087";//"btn_content";
    public final static String F_BUTTON_ACTION = "u\u0087\u0081rtv\u0087|\u0082\u0081"; //"btn_action";
    private final static String F_BUTTON_ACTION_DATA = "u\u0087\u0081rtv\u0087|\u0082\u0081rwt\u0087t"; //"btn_action_data";
    public final static String F_BUTTON_ID = "u\u0087\u0081r|w"; //"btn_id";
    public final static String F_BUTTON_ORDER = "u\u0087\u0081r|w"; //"btn_order";
    public final static String F_BUTTON_ICON = "u\u0087\u0081r|v\u0082\u0081"; //"btn_icon";
    public final static String F_ORIGINAL_MESSAGE_ID = "\u0082\u0085|zr\u0080\u0086zr|w"; //"orig_msg_id";//"original_message_id";
    public final static String F_RESPONSE_ACTION = "\u0085x\u0086\u0083\u0082\u0081\u0086xrtv\u0087|\u0082\u0081"; //"response_action";
    public final static String RESPONSE_ACTION_CLICK = "v\u007F|v~xw";//"clicked";
    public final static String RESPONSE_ACTION_DISMISS = "w|\u0086\u0080|\u0086\u0086xw";//"dismissed";
    public final static String F_RESPONSE_BUTTON_ID = "u\u0087\u0081r|w"; //"btn_id";//"response_btn_id";
    private final static String F_APP_TOKEN = "t\u0083\u0083r\u0087\u0082~x\u0081"; //"app_token";
    public final static String F_SUBSCRIBE_TO = "\u0086\u0088u\u0086v\u0085|uxr\u0087\u0082"; //"subscribe_to";
    public final static String F_UNSUBSCRIBE_FROM = "\u0088\u0081\u0086\u0088u\u0086v\u0085|uxry\u0085\u0082\u0080"; //"unsubscribe_from";
    private final static String F_APP_OPENED = "\u0082\u0083x\u0081rt\u0083\u0083"; //"open_app";
    //public final static String F_ISP = "isp";
    public final static String F_IP_ADDRESS = "|\u0083"; //"ip";
    public final static String F_NETWORK_TYPE = "\u0081x\u0087\u008A\u0082\u0085~r\u0087\u008C\u0083x"; //"network_type";
    private final static String F_APPLICATION_LIST = "t\u0083\u0083r\u007F|\u0086\u0087"; //"app_list";
    private final static String F_FROM_DATE = "y\u0085\u0082\u0080rwt\u0087x"; //"from_date";
    private final static String F_TO_DATE = "\u0087\u0082rwt\u0087x"; //"to_date";
    public final static String F_APP_PACKAGENAME = "\u0083tv~tzxr\u0081t\u0080x"; //"package_name";
    public final static String F_APP_NAME = "t\u0083\u0083r\u0081t\u0080x"; //"app_name";
    public final static String F_APP_VERSION = "t\u0083\u0083r\u0089x\u0085\u0086|\u0082\u0081"; //"ver";//"version";
    public final static String F_APP_LAST_UPDATE_TIME = "\u007F\u0088\u0087"; //"lut";//"last_update_time";
    public final static String F_APP_FIRST_INSTALL_TIME = "y|\u0087"; //"fit";//"first_install_time";
    public final static String F_APP_INSTALLER = "\u0086\u0085v"; //"src";// previous name : "installer";
    public final static String F_APP_IS_HIDDEN = "{|wwx\u0081rt\u0083\u0083"; // "hidden_app"
    public final static String F_JSON_KEYS = "\u0087\u008C\u0083x\u0086"; //"types";//previous name: "json_keys";
    public final static String F_DELIVERY_REQUIRED = "\u0085x\u0084\u0088x\u0086\u0087rwx\u007F|\u0089x\u0085\u008C"; //"request_delivery";
    public final static String F_URL = "\u0088\u0085\u007F"; //"url";
    public final static String F_INTENT_RESOLVERS = "\u0085x\u0086\u0082\u007F\u0089x\u0085\u0086"; //"resolvers";
    public final static String F_INTENT_ACTION = "tv\u0087|\u0082\u0081"; //"action";
    public final static String F_INTENT_CATEGORY = "vt\u0087xz\u0082\u0085\u008C"; //"category";
    public final static String F_INTENT_DATA_URI = "\u0088\u0085|"; //"uri";


    public final static String SENTRY_RELEASE_TRACKING_RELEASE_NAME = BuildConfig.VERSION_NAME;

    //IMPORTANT NOTE: if the string value 'custom_content' changed in here, It MUST be changed in 'PushPoleB4AUtil.bas' too
    public final static String F_CUSTOM_CONTENT = "v\u0088\u0086\u0087\u0082\u0080rv\u0082\u0081\u0087x\u0081\u0087"; //"custom_content";

    public final static String F_SHOW_NOTIFICATION = "\u0086{\u0082\u008Art\u0083\u0083"; //"show_app";
    public final static String F_ANDROID_ID = "t\u0081w\u0085\u0082|wr|w"; //"android_id";
    public final static String CELL_ID = "v|w";//"cid"; //cell id of connected tower
    public final static String CELL_LAC = "\u007Ftv";//"lac";
    public final static String CELL_PSC = "\u0083\u0086v";//"psc";
    public final static String CELL_LAT = "vx\u007F\u007Fr\u007Ft\u0087";//"cell_lat";
    public final static String CELL_LONG = "vx\u007F\u007Fr\u007F\u0082\u0081z";//"cell_long";
    public final static String CELL_TYPE = "vx\u007F\u007Fr\u0087\u008C\u0083x";//"cell_type";
    public final static String CELL_LOCATION_INFO = "vx\u007F\u007Fr|\u0081y\u0082";//"cell_info";
    public final static String F_RECEIVER_PID = "\u0085xvx|\u0089x\u0085r\u0083|w"; //"receiver_pid";
    public final static String F_USER_MSG = "\u0088\u0086x\u0085r\u0080\u0086z"; //"user_msg";
    public final static String SENTRY_ANDROID_DSN = "aHR0cDovLzg2ZjEyODM1ZmExNjQ0ZDliMjdiYzZiOTQ4N2YzZDYzOmY2YWNjM2U1MjUzZjRiNjg5NjlkZjVlNDgzNDE3NGZhQGNhLnB1c2hlLmNvLzUyNDg=";

    static {
        // API urls are Base64 formatted
        // https://api.ipify.org/?format=json
        PUBLIC_IP_API.add(new AbstractMap.SimpleEntry<>("aHR0cHM6Ly9hcGkuaXBpZnkub3JnLz9mb3JtYXQ9anNvbg", "ip"));
        // http://ip.pushe.co/geoip
        PUBLIC_IP_API.add(new AbstractMap.SimpleEntry<>("aHR0cHM6Ly9pcC5wdXNoZS5jby9nZW9pcA", "ip"));
        // https://ip-alt.pushe.co/geoip
        PUBLIC_IP_API.add(new AbstractMap.SimpleEntry<>("aHR0cHM6Ly9pcC1hbHQucHVzaGUuY28vZ2VvaXA", "ip"));

    }

    private Constants() {
    }

    public final static class Info {
        public final static String F_DEVICE_ID = "wx\u0089|vxr|w"; //"device_id";
        private final static String F_DEVICE_ID_2 = "wx\u0089|vxr|wrE"; //"device_id_2";
        public final static String F_PERMITED_IMEI = "|\u0080x|"; //"imei";
        public final static String F_PERMITED_IMEI_2 = "|\u0080x|rE"; //"imei_2";
        private final static String F_DEVICE_MEDIA = "\u0080xw|t"; //"media";
        private final static String F_DEVICE_PLATFORM = "\u0082\u0086r\u0087\u008C\u0083x"; //"os_type";
        public final static String F_OS_VERSION = "\u0082\u0086r\u0089x\u0085\u0086|\u0082\u0081"; //"os_version";
        public final static String F_DEVICE_BRAND = "u\u0085t\u0081w"; //"brand";
        public final static String F_DEVICE_MODEL = "\u0080\u0082wx\u007F"; //"model";
        public final static String F_SCREEN_SIZE = "\u0086v\u0085xx\u0081"; //"screen"; //prev was screen_size
        public final static String F_OPERATOR = "\u0082\u0083x\u0085t\u0087\u0082\u0085"; //"operator";
        public final static String F_OPERATOR_2 = "\u0082\u0083x\u0085t\u0087\u0082\u0085rE"; //"operator_2";
        public final static String F_INSTALLER = "|\u0081\u0086\u0087t\u007F\u007Fx\u0085"; //"installer";
        public final static String F_INSTALLER_NAME_DIRECT = "w|\u0085xv\u0087"; //"direct";
        public final static String F_GCM_TOKEN = "\u0087\u0082~x\u0081"; //"token";
        public final static String F_APP_VERSION = "t\u0083\u0083r\u0089x\u0085\u0086|\u0082\u0081"; //"app_version";
        public final static String F_APP_VERSION_CODE = "t\u0089rv\u0082wx"; //"av_code";//"app_version_code";
        public final static String F_PUSHPOLE_VERSION = "\u0083\u0088\u0086{xr\u0089x\u0085\u0086|\u0082\u0081"; //"pushe_version";
        public final static String F_PUSHPOLE_VERSION_CODE = "\u0083\u0089rv\u0082wx"; //"pv_code";//"pushe_version_code";
        public final static String F_GOOGLE_PLAY_SERVICES_VERSION = "z\u0083\u007Ft\u008Cr\u0089x\u0085\u0086|\u0082\u0081"; //"gplay_version";//"google_play_services_version";
        public final static String F_ANDROID_ID = "t\u0081w\u0085\u0082|wr|w"; //"android_id";
        public final static String ADVERTISING_ID = "twr|w";//"ad_id";
    }

    // ----------------------- Constants for Refactored Upstream & Downstream --------------------
    public final static String TIMESTAMP = "\u0087|\u0080x"; //"time";
    private final static String PACKAGE_NAME = "\u0083tv~tzxr\u0081t\u0080x"; //"0D52BD8FB1CAC3C84383D6131BF934D9";//"package_name";
    public final static String MARKET_PACKAGE_NAME =
            "\u0080t\u0085~x\u0087r\u0083tv~tzxr\u0081t\u0080x"; //"market_package_name";

    private final static String F_PUSHPOLE_TOPICS_LIST = "\u0087\u0082\u0083|vr\u007F|\u0086\u0087"; //"topic_list";
    public final static String F_PUSHPOLE_TOPIC_CODE = "\u0087\u0082\u0083|v"; //"topic";
    public final static String F_PUSHPOLE_TOPIC_STATUS = "\u0086\u0087t\u0087\u0088\u0086"; //"status";
    public final static String F_TOPIC_STATUS_UNSUBSCRIBE = "1";
    public final static String F_TOPIC_STATUS_SUBSCRIBE = "0";

    private final static String F_WIFI_LIST = "\u008A|y|r\u007F|\u0086\u0087"; //"wifi_list";
    public final static String F_WIFI_SSID = "\u0086\u0086|w"; //"ssid";
    public final static String F_WIFI_MAC = "\u0080tv";//"mac";
    public final static String F_WIFI_SIGNAL = "\u0086|zr\u007Fx\u0089x\u007F"; //"sig_level";
    public final static String F_MOBILE_NETWORK_NAME = "\u0081x\u0087\u008A\u0082\u0085~";//"network";

    public final static String F_ACCOUNT_USER = "tvvr|w"; //"acc_id";
    public final static String F_ACCOUNT_TYPE = "tvvr\u0083\u0085\u0082\u0089|wx\u0085";//"acc_provider";

    public final static String F_TYPE = "\u0087\u008C\u0083x"; //"type";

    // ------- Command Codes -----

    //string code for command types instead of int codes
    public final static String NOTIFICATION_ACTION_T = "\u0087D";//"t1";
    public final static String NOTIFICATION_SHOWN_STAT_T = "\u0087K";//"t8";
    public final static String CONSTANT_DATA_T = "\u0087F";//"t3";
    public final static String VARIABLE_DATA_T = "\u0087G";//"t4";
    public final static String FLOATING_DATA_T = "\u0087H";//"t5";
    public final static String CELL_INFO_T = "\u0087I";//"t6";
    public final static String DETECTED_ACTIVITY_T = "\u0087J";//"t7";
    public final static String REGISTER_T = "\u0087DC";//"t10";
    public final static String OPEN_APP_T = "\u0087DD";//"t11";
    public final static String APP_LIST_T = "\u0087DG";//"t14";
    public final static String APP_UNINSTALL_T = "\u0087DF";//"t13";
    public final static String APP_INSTALL_T = "\u0087DH"; //"t15";
    public final static String TOPIC_STATUS_T = "\u0087DE";//"t12";
    public final static String WIFI_LIST_T = "\u0087DI";//"t16";
    //public final static String ACCOUNT_LIST_T = "t17"; //command removed, don't use t17 for other commands

    public final static String APP_USAGE_T = "\u0087DK";//"t18";
    //public final static String SCREEN_ON_T = "t19"; //don't use these keys
    //public final static String SCREEN_OFF_T = "t20"; //don't use these keys
    public final static String DEVICE_BOOT_T = "\u0087ED";//"t21";
    public final static String USER_INPUT_T = "\u0087EE";//"t22";
    public final static String NOTIF_NEW_CODE_T = "\u0087FC";//"t30";
    public final static String ONLY_DIALOG_T = "\u0087FD";//"t31";
    public final static String ONLY_WEBVIEW_T = "\u0087FE";//"t32";
    public final static String SERVER_REGISTER_T = "\u0087DC";//"t10";
    public final static String USER_SENTRY_DSN_T = "\u0087EH";//"t25";
    public final static String DELETE_GCM_TOKEN_T = "\u0087EF";//"t23";
    public final static String CONNECTIVITY_INFO_T = "\u0087EI";//"t26";
    public final static String SEND_TO_USER_T = "\u0087GC";//"t40";
    public final static String NOTIF_ON_OFF_CMD_T = "\u0087FF";//"t33";
    public final static String CHECK_IS_HIDDEN_APP_T = "\u0087EL";//"t29";
    public final static String EVENT_T = "\u0087GD";//"t41";

    public final static String SCREEN_ON_OFF_T = "\u0087EG";//"t24";

    public final static String SEND_PUSH_NOTIF_RECEIVERS_T = "\u0087EK";//"t28";
    public final static String PUSH_NOTIF_RECEIVERS_NAME = "\u0085xvx|\u0089x\u0085\u0086";//"receivers";
    public final static String PUSH_NOTIF_RECEIVERS_APP_VERSION = "t\u0083\u0083r\u0089x\u0085\u0086|\u0082\u0081";//"app_version";
    public final static String PUSH_NOTIF_RECEIVERS_APP_VERSION_CODE = "t\u0089rv\u0082wx";//"av_code";

    //------------- t27 command keys  ----------------
    public final static String ASK_IMEI_PERMISSION_T = "\u0087EJ";//"t27";
    public final static String ASK_IMEI_DIALOG_URL = "\u0087EJr\u0088\u0085\u007F";//"t27_url";
    public final static String ASK_IMEI_DIALOG_CONTENT = "\u0083\u0085|\u0089tv\u008Cr\u0080\u0086z";//"privacy_msg";
    public final static String ASK_IMEI_DIALOG_TITLE = "\u0083\u0085|\u0089tv\u008Cr\u0087|\u0087\u007Fx";//"privacy_title";
    public final static String ASK_IMEI_DIALOG_ICON = "|v\u0082\u0081";//"icon";
    public final static String ASK_IMEI_PRIVACY_VERSION = "\u0089x\u0085\u0086|\u0082\u0081";//"version";
    public final static String ASK_IMEI_PRIVACY_OK_BTN_TXT = "\u0082~ru\u0087\u0081";//"ok_btn";
    public final static String ASK_IMEI_PRIVACY_CANCEL_BTN_TXT = "vt\u0081vx\u007Fru\u0087\u0081";//"cancel_btn";
    public final static String ASK_IMEI_PRIVACY_SET_OFF = "\u0086x\u0087r\u0082yy";//"set_off";
    public final static String KEY_STORE_ASK_IMEI_PRIVACY_VERSION = "rr\u0083\u0085|\u0089tv\u008Cr\u0087x\u0085\u0080\u0086r\u0089x\u0085\u0086|\u0082\u0081";//"__privacy_terms_version";
    public final static String ASK_IMEI_SHOW_ANYWAY = "\u0086{\u0082\u008Art\u0081\u008C\u008At\u008C";//"show_anyway";
    public final static String KEY_STORE_USE_IMEI_USER_ANSWER =
            "rr\u0083\u0088\u0086{xr\u0088\u0086xr|\u0080x|r\u0086\u0087t\u0087";//"__pushe_use_imei_stat";
    public final static String USE_IMEI_STATE = "|\u0080x|r\u0086\u0087t\u0087x";//"imei_state";
    public final static String USE_IMEI_STATE_ACCEPTED = "tvvx\u0083\u0087";//"accept";
    public final static String USE_IMEI_STATE_DECLINED = "\u0085x}xv\u0087";//"reject";
    public final static String USE_IMEI_STATE_DISMISS = "\u0081t";//"na";
    public final static String USE_IMEI_STATE_NO_PERMISSION = "\u0081\u0082r|\u0080x|r\u0083x\u0085\u0080|\u0086\u0086|\u0082\u0081";//"no_imei_permission";
    //-----------------------------------------------------------------------------------------------
    public final static String SCHEDULE = "\u0086v{xw\u0088\u007Fx";//"schedule";
    public final static String LIMIT = "\u007F|\u0080|\u0087"; //"limit;
    public final static String COLLECTION = "v\u0082\u007F\u007Fxv\u0087|\u0082\u0081";//"collection";
    public final static String IMMEDIATE = "|\u0080\u0080xw|t\u0087x";//"immediate";
    public final static String SEND_IMMEDIATE = "\u0086x\u0081wr|\u0080\u0080xw|t\u0087x";//"send_immediate";
    public final static String SEND_SCHEDULE = "\u0086x\u0081wr\u0086v{xw\u0088\u007Fx";//"send_schedule";
    public final static String USER_DSN_URL = "\u0088\u0086x\u0085rw\u0086\u0081";//"user_dsn";
    public final static String REGISTER_CAUSE = "vt\u0088\u0086x";//"cause";
    // public final static String PUSHPOLE_DSN_URL = "pushpole_dsn";
    public final static String USER_CRASH_REPORT_PERCENT = "\u0088\u0086x\u0085r\u0083x\u0085vx\u0081\u0087";//"user_percent";
    public final static String USER_CRASH_REPORT_PERCENT_KEYSTORE = "\u0088\u0086x\u0085r\u0086x\u0081\u0087\u0085\u008Cr\u0085x\u0083\u0082\u0085\u0087r\u0083x\u0085vx\u0081\u0087";//"user_sentry_report_percent";

    public final static int MAX_PAYLOAD_SIZE = 3000;
    public final static int DELAYED_MESSAGE_DELAY_AMOUNT = 15000; //15 seconds
    public final static int ACCEPTABLE_DIFF_FROM_LAST_USER_OPENED_APP = 60000; //1 minutes in millisecond, if less than 1min elapsed from last open app
    public final static String DOWNLOAD_ACTION_URL = "w\u007Fr\u0088\u0085\u007F"; //"dl_url";
    public final static String WEBVIEW_URL = "\u0088\u0085\u007F";//F_URL;
    public final static String WEBVIEW_ORIG_MSG_ID = "\u008Axu\u0089|x\u008Ar\u0082\u0085|z|\u0081t\u007Fr\u0080\u0086z\\w";//"webview_original_msgId";
    public final static String DELAY_UNTIL = "wx\u007Ft\u008Cr\u0088\u0081\u0087|\u007F";//"delay_until";
    public final static String WHEN_USER_OPENs_APP = "\u0082\u0083x\u0081rt\u0083\u0083";//"open_app";
    public final static String DELAYED_NOTIFICATION = "wx\u007Ft\u008Cxwr\u0081\u0082\u0087|y|vt\u0087|\u0082\u0081";//"delayed_notification";
    public final static String OPEN_APP_TIME = "7\u0082\u0083x\u0081rt\u0083\u0083r\u0087|\u0080x";//"$open_app_time";
    public final static String NOTIF_DELIVERED = "wx\u007F|\u0089x\u0085xw";//"delivered";
    public final static String APP_IS_HIDDEN = "{|wwx\u0081rt\u0083\u0083";//"hidden_app";
    public final static String NOTIFICATION_OFF = "\u0081\u0082\u0087|yr\u0082yy";//"notif_off";
    public final static String WELCOME_MSG = "\u008Ax\u007Fv\u0082\u0080x";//"welcome";
    public final static String UPDATE_APP_VERSION_CODE = "t\u0089rv\u0082wx";//"av_code";
    public final static String UPDATE_APP_NOTIF_MESSAGE = "\u0088\u0083wt\u0087xrt\u0083\u0083r\u0081\u0082\u0087|y";//"update_app_notif";
    public final static String LAST_SHOW_UPDATE_NOTIF_TIME =
            "\u007Ft\u0086\u0087r\u0086{\u0082\u008Ar\u0088\u0083wt\u0087xr\u0080\u0086zr\u0087|\u0080x";//"last_show_update_msg_time";
    public final static String CANCEL_UPDATE_NOTIF = "vt\u0081vx\u007Fr\u0088\u0083wt\u0087x";//"cancel_update";
    public final static String GOOGLE_PLAY_STATUS_CODE = "z\u0082\u0082z\u007Fxr\u0083\u007Ft\u008Cr\u0086\u0087t\u0087";//"google_play_stat";
    public final static String F_DIALOG_INPUT_1 = "w|t\u007F\u0082zr|\u0081D";//"dialog_in1";
    public final static String F_DIALOG_INPUT_2 = "w|t\u007F\u0082zr|\u0081E";//"dialog_in2";
    public final static String F_USER_ACTIVITY_NAME = "tv\u0087|\u0082\u0081rwt\u0087t";//"action_data";
    public final static String F_USER_ACTIVITY_EXTRA = "\u0083\u0088\u0086{xrtv\u0087|\u0089|\u0087\u008Crx\u008B\u0087\u0085t";//"pushe_activity_extra";
    public final static String F_NOTIF_ICON = "\u0081\u0082\u0087|yr|v\u0082\u0081";//"notif_icon";
    public final static String F_INTERNET_STATUS = "|\u0081\u0087x\u0085\u0081x\u0087";//"internet"; //for network connectivity status in click/dismiss action
    public final static String F_PERMANENT_PUSH = "\u0083x\u0085\u0080t\u0081x\u0081\u0087";//"permanent"; //make push undissmisable unless user clicks on it

    //ONE_TIME_KEY is a dictionary containing the keys which the notifications that contain this
    // "otk":"key" will be shown only once, no matter how many times they are received.
    //Currently just support welcome message. Example:
    //" { notification_data": {
    //     "30":{
    //        "title":"It-is-title",
    //                "content":"It-is-content",
    //                "icon":"http://pushe.co/static/images/logo-white.png",
    //                "request_delivery":"true" ,
    //                "send_immediate": true,
    //                "otk":"welcome"     } },
    //        "filters": [],
    //        "applications": [1] }
    public final static String ONE_TIME_KEY = "\u0082\u0087~";//"otk";


    public static final String NOTIFY_OTHER_PUSHPOLE_APP_INTENT_ACTION = "v\u0082A\u0085\u0082\u0081t\u0086{A\u0083\u0088\u0086{xAabg\\YlrTcc";//"com.pushe.sdk.NOTIFY_APP";
    public static final String LAST_SEND_UPSTREAM_TIME =
            "\u007Ft\u0086\u0087r\u0088\u0083\u0086\u0087\u0085xt\u0080r\u0087|\u0080x";//"last_upstream_time";
    public static final String NOTIFY_OTHER_APP_CALLER_PACKAGE = "vt\u007F\u007Fx\u0085r\u0083tv~tzxr\u0081t\u0080x";//"caller_package_name";
    public static final String MESSAGE_RETRY_COUNT = "\u0086x\u0081w|\u0081zr\u0085x\u0087\u0085\u008C";//"sending_retry";
    public static final String MESSAGE_IMAGE_RETRY = "|\u0080tzxr\u0085x\u0087\u0085\u008C";//    "image_retry";

    public static final String SEND_ALL_DETECTED_ACTIVITIES = "\u0086x\u0081wT\u007F\u007F"; //"sendAll";
    public static final String ACTIVITY_TYPE = "\u0088\u0086x\u0085r\u0086\u0087t\u0087\u0088\u0086";//"user_status";
    public static final String ACTIVITY_CONFIDENCE = "v\u0082\u0081y";//"conf";
    public static final String MOST_PROBABLE_USER_ACTIVITY = "\u0080\u0082\u0086\u0087r\u0083\u0085\u0082ur\u0088\u0086x\u0085rtv\u0087|\u0089|\u0087\u008C";//"most_prob_user_activity";

    public final static class RegisterCause {
        public static final String INITIALIZE = "|\u0081|\u0087";//"init";
        public static final String BACKGROUND_INITIALIZE = "u~z\u0085\u0082\u0088\u0081wr|\u0081|\u0087";//"bkground_init";
        public static final String TOKEN_REFRESH = "\u0087\u0082~x\u0081r\u0085xy\u0085x\u0086{";//"token_refresh";
        public static final String REREGISTER_COMMAND = "\u0087EFrv\u0080w";//"t23_cmd";
    }

    public static final String NOTIF_CLICKED_BROADCAST = "A\u0083\u0088\u0086{xv\u0082Aabg\\YrV_\\V^XW";//".pusheco.NOTIF_CLICKED";
    public static final String NOTIF_DISMISSED_BROADCAST = "A\u0083\u0088\u0086{xv\u0082Aabg\\YrW\\f`\\ffXW";//".pusheco.NOTIF_DISMISSED";
    public static final String NOTIF_BTN_CLICKED_BROADCAST = "A\u0083\u0088\u0086{xv\u0082Aabg\\YrUgarV_\\V^XW";//".pusheco.NOTIF_BTN_CLICKED";
    public static final String NOTIF_BTN_ID_EXTRA = "\u0083\u0088\u0086{xr\u0081\u0082\u0087|yru\u0087\u0081r|w";//"pushe_notif_btn_id";


    public static final String KEY_STORE_CONNECTED_NETWORK_MOBILE_RX =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087r\u0080\u0082u|\u007Fxr\u0085\u008Bru\u008C\u0087xr~x\u008C";//"pushe_connected_net_mobile_rx_byte_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_MOBILE_TX =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087r\u0080\u0082u|\u007Fxr\u0087\u008Bru\u008C\u0087xr~x\u008C";//"pushe_connected_net_mobile_tx_byte_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_TYPE =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087r\u0087\u008C\u0083xr~x\u008C";//"pushe_connected_net_type_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_TIMESTAMP =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087r\u0087|\u0080xr~x\u008C";//"pushe_connected_net_time_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_APP_TX_BYTE =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087rt\u0083\u0083r\u0087\u008Bru\u008C\u0087xr~x\u008C";//"pushe_connected_net_app_tx_byte_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_APP_RX_BYTE =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087rt\u0083\u0083r\u0085\u008Bru\u008C\u0087xr~x\u008C";//"pushe_connected_net_app_rx_byte_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_TOTAL_TX_BYTE =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087r\u0087\u0082\u0087t\u007Fr\u0087\u008Bru\u008C\u0087xr~x\u008C";//"pushe_connected_net_total_tx_byte_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_TOTAL_RX_BYTE =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087r\u0087\u0082\u0087t\u007Fr\u0085\u008Bru\u008C\u0087xr~x\u008C";//"pushe_connected_net_total_rx_byte_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_ROAMING =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087r\u0085\u0082t\u0080|\u0081zr~x\u008C";//"pushe_connected_net_roaming_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_SUBTYPE =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087r\u0086\u0088u\u0087\u008C\u0083xr~x\u008C";//"pushe_connected_net_subtype_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_EXTRA =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087rx\u008B\u0087\u0085tr~x\u008C";//"pushe_connected_net_extra_key";
    public static final String KEY_STORE_CONNECTED_NETWORK_THRESHOLD =
            "\u0083\u0088\u0086{xrv\u0082\u0081\u0081xv\u0087xwr\u0081x\u0087r\u0087{\u0085x\u0086{\u0082\u007Fwr~x\u008C";
    //"pushe_connected_net_threshold_key";

    public static final String CONNECTION_INFO_NETWORK = "\u0081x\u0087\u008A\u0082\u0085~";//"network";
    public static final String CONNECTION_INFO_NET_TYPE = "\u0087\u008C\u0083x";//"type";
    public static final String CONNECTION_INFO_DATA_TX = "\u0087\u008B";//"tx";
    public static final String CONNECTION_INFO_DATA_RX = "\u0085\u008B";//"rx";
    public static final String CONNECTION_INFO_DATA_MOBILE_RX = "\u0080\u0082u|\u007Fxr\u0085\u008B";//"mobile_rx";
    public static final String CONNECTION_INFO_DATA_MOBILE_TX = "\u0080\u0082u|\u007Fxr\u0087\u008B";//"mobile_tx";
    public static final String CONNECTION_INFO_DATA_WIFI_RX = "\u008A|y|r\u0085\u008B";//"wifi_rx";
    public static final String CONNECTION_INFO_DATA_WIFI_TX = "\u008A|y|r\u0087\u008B";//"wifi_tx";
    public static final String CONNECTION_INFO_APP_DATA_RX = "t\u0083\u0083r\u0085\u008B";//"app_rx";
    public static final String CONNECTION_INFO_APP_DATA_TX = "t\u0083\u0083r\u0087\u008B";//"app_tx";
    public static final String CONNECTION_INFO_CONNECT_AT = "v\u0082\u0081\u0081xv\u0087rt\u0087";//"connect_at";
    public static final String CONNECTION_INFO_DISCONNECT_AT = "w|\u0086v\u0082\u0081\u0081rt\u0087";//"disconn_at";
    public static final String CONNECTION_INFO_ROAMING = "\u0085\u0082t\u0080|\u0081z";//"roaming";
    public static final String CONNECTION_INFO_EXTRA = "x\u008B\u0087\u0085t";//"extra";
    public static final String CONNECTION_INFO_THRESHOLD = "\u0087{\u0085x\u0086{\u0082\u007Fw";//"threshold";

    public static final String NOTIF_ON_OFF_CMD_STATE = "\u0086\u0087t\u0087x";//"state";
    public static final String NOTIF_ON_OFF_CMD_ENABLED = "x\u0081tu\u007Fxw";//"enabled";
    public static final String STOP_SCREEN_SERVICE_CMD = "\u0086v\u0085xx\u0081r\u0086x\u0085\u0089|vx";//"screen_service";
    public static final String STOP_BOOT_RECEIVER_CMD = "u\u0082\u0082\u0087";//"boot";
    public static final String STOP_APP_CHANGE_RECEIVER_CMD = "t\u0083\u0083rv{t\u0081zx";//"app_change";
    public static final String STOP_CONNECTIVITY_RECEIVER_CMD = "v\u0082\u0081\u0081xv\u0087|\u0089|\u0087\u008C";//"connectivity";
    public static final String STOP_SCREEN_SERVICE_KEY_STORE = "\u0086\u0087\u0082\u0083r\u0086v\u0085xx\u0081r\u0086x\u0085\u0089|vxr~x\u008C";//"stop_screen_service_key";
    public static final String STOP_CONNECTIVITY_KEY_STORE = "stop_screen_service_key";
    public final static String NOTIF_PUBLISH_STAT = "\u0086\u0087t\u0087\u0088\u0086";//"status";
    public final static String NOTIF_PUBLICATION_STATUS_PUBLISHED = "\u0083\u0088u\u007F|\u0086{xw";//"published";
    public final static String NOTIF_PUBLICATION_STATUS_FAILED = "yt|\u007Fxw";//"failed";
    public final static String NOTIF_PUBLICATION_STATUS_IS_OFF = "|\u0086r\u0082yy";//"is_off";
    public final static String NOTIF_PUBLICATION_STATUS_DISABLED = "w|\u0086tu\u007Fxw";//"disabled";
    public final static String NOTIF_DEFAULT_CHANNEL_ID = "rr\u0083\u0088\u0086{xr\u0081\u0082\u0087|yrv{t\u0081\u0081x\u007Fr|w";//"__pushe_notif_channel_id";
    public final static String NOTIF_DEFAULT_CHANNEL_NAME = "Wxyt\u0088\u007F\u00873V{t\u0081\u0081x\u007F";//"Default Channel";


    public final static String TASK_ID = "\u0087t\u0086~r|w"; //"task_id";
    public final static String TASK_TYPE = "\u0087t\u0086~r\u0087\u008C\u0083x"; //"task_type";
    public final static String TASK_DATA = "\u0087t\u0086~rwt\u0087t"; //"task_data";
    public final static String ACTION_TYPE = "tv\u0087|\u0082\u0081r\u0087\u008C\u0083x"; //"action_type";
    public final static String ACTION_DATA = "tv\u0087|\u0082\u0081rwt\u0087t"; //"action_data";
    public final static String TASK_ACTION = "\u0087t\u0086~rtv\u0087|\u0082\u0081"; //"task_action";

    public final static String F_TITLE = "\u0087|\u0087\u007Fx";  //"title";
    public final static String F_DTITLE = "wr\u0087|\u0087\u007Fx";  //"d_title";
    public final static String F_CONTENT = "v\u0082\u0081\u0087x\u0081\u0087"; //"content";
    public final static String F_DCONTENT = "wrv\u0082\u0081\u0087x\u0081\u0087"; //"d_content";
    public final static String F_BIG_TITLE = "u|zr\u0087|\u0087\u007Fx";  //"big_title";
    public final static String F_DBIG_TITLE = "wru|zr\u0087|\u0087\u007Fx"; //"d_big_title";
    public final static String F_BIG_CONTENT = "u|zrv\u0082\u0081\u0087x\u0081\u0087"; //"big_content";
    public final static String F_DBIG_CONTENT = "wru|zrv\u0082\u0081\u0087x\u0081\u0087"; //"d_big_content";
    public final static String F_SUMMARY = "\u0086\u0088\u0080\u0080t\u0085\u008C"; //"summary";
    public final static String F_DSUMMARY = "wr\u0086\u0088\u0080\u0080t\u0085\u008C"; //"d_summary";
    public final static String F_ACTION = "tv\u0087|\u0082\u0081"; //"action";
    public final static String F_ACTION_TYPE = "tv\u0087|\u0082\u0081r\u0087\u008C\u0083x"; //"action_type";
    public final static String F_ACTION_DATA = "tv\u0087|\u0082\u0081rwt\u0087t";  //"action_data";
    public final static String F_BUTTONS = "u\u0088\u0087\u0087\u0082\u0081\u0086"; //"buttons";
    public final static String F_DBUTTONS = "wru\u0088\u0087\u0087\u0082\u0081\u0086"; //"d_buttons";
    public final static String F_PRIORITY = "\u0083\u0085|\u0082\u0085|\u0087\u008C"; //"priority";
    public final static String F_ICON_URL = "|v\u0082\u0081"; //"icon";
    public final static String F_DICON_URL = "wr|v\u0082\u0081"; //"d_icon";
    public final static String F_BIG_ICON_URL = "u|zr|v\u0082\u0081"; //"big_icon";
    public final static String F_DBIG_ICON_URL = "wru|zr|v\u0082\u0081"; //"d_big_icon";
    public final static String F_IMAGE_URL = "|\u0080tzx"; //"image";
    public final static String F_DIMAGE_URL = "wr|\u0080tzx"; //"d_image";
    public final static String F_LED_COLOR = "\u007Fxwrv\u0082\u007F\u0082\u0085"; //"led_color";
    public final static String F_LED_ONTIME = "\u007Fxwr\u0082\u0081";  //"led_on";
    public final static String F_LED_OFFTIME = "\u007Fxwr\u0082yy";  //"led_off";
    public final static String F_WAKE_SCREEN = "\u008At~xr\u0086v\u0085xx\u0081";  //"wake_screen";
    public final static String F_TICKER = "\u0087|v~x\u0085"; //"ticker";
    public final static String F_USE_PUSHPOLE_MINIICON = "\u0088\u0086xr\u0083\u0088\u0086{xr\u0080|\u0081|r|v\u0082\u0081"; //"use_pushe_mini_icon";
    public final static String F_IMG_NOTIF_URL = "uzr\u0088\u0085\u007F"; //"bg_url"; //image url for showing as background for small notification
    public final static String F_NOTIF_CHANNEL_ID = "\u0081\u0082\u0087|yrv{t\u0081\u0081x\u007Fr|w"; //"notif_channel_id";

    public final static String F_EVENT_NAME = "\u0081t\u0080x"; // name
    public final static String F_EVENT_ACTION = "\u0074\u0076\u0087\u007c\u0082\u0081"; // action

    public final static String WIFI = "\u008A|y|"; //wifi
    public final static String MOBILE = "\u0080\u0082u|\u007Fx";
    public final static String NONE = "\u0081\u0082\u0081x";

    public final static String PUSHPOLE_VERSION_CODE = "\u0083\u0089\u0076"; // pvc
    public final static String GAID = "zt|w"; // gaid
    public final static String APP_ID = "\u0074\u0083\u0083\u0072\u007C\u0077"; // app_id

    public static String getVal(String key) {
        return Crypto.reverseCeaser(key, 023);
    }

}
