package com.pushpole.sdk.message.upstream;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.message.Message;
import com.pushpole.sdk.util.IdGenerator;
import com.pushpole.sdk.util.Pack;

/***
 * Base class for generating upstream messages
 */
public abstract class UpstreamMessageFactory {
    public abstract UpstreamMessage buildMessage(Pack pack);

    /***
     * set message ID
     *
     * @param message the message
     * @param data    the data that contains ID
     */
    protected void populateMessage(Message message, Pack data) {
        String messageId = data.getString(Constants.getVal(Constants.F_MESSAGE_ID), null);
        message.setMessageId(messageId);
    }

    /***
     * set message ID with UUID
     *
     * @param message the message
     */
    protected void populateMessage(Message message) {
        message.setMessageId(generateMsgId());
    }

    public static String generateMsgId(){
        return IdGenerator.generateUUID(PlainConstants.F_MSG_ID_LENGTH);
    }
}
