package com.pushpole.sdk.internal.log;

import android.content.Context;

import com.pushpole.sdk.internal.db.KeyStore;

public class StatsCollector {
    /**
     * Number of total messages sent, including delivery messages
     */
    public final static String STAT_SENT_MESSAGES = "$stats_sent_messages";
    public final static String STAT_SENT_DELIVERIES = "$stats_sent_deliveries";
    public final static String STAT_SENT_ERRORS = "$stats_sent_errors";
    /**
     * Number of total sending attempts, not including attempts that were because of no available locations
     */
    public final static String STAT_SEND_ATTEMPTS = "$stats_send_attempts";
    public final static String STAT_DELETED_MESSAGES = "$stats_deleted_messages";
    public final static String STAT_ACKED_MESSAGES = "$stats_acked_messages";
    public final static String STAT_RECV_MESSAGES = "$stats_recv_messages";
    public final static String STAT_BAD_RECV_MESSAGES = "$stats_bad_recv_messages";
    public final static String STAT_RECV_RESPONSE = "$stats_recv_response";

    private volatile static StatsCollector mInstance;

    public static void increment(Context context, String key) {
        getInstance().incrementStat(context, key);
    }

    public static int get(Context context, String key) {
        return getInstance().getStat(context, key);
    }

    public static StatsCollector getInstance() {
        if (mInstance == null) {
            synchronized (StatsCollector.class) {
                if (mInstance == null) {
                    mInstance = new StatsCollector();
                }
            }
        }
        return mInstance;
    }

    public void incrementStat(Context context, String key) {
        KeyStore.getInstance(context).putInt(key, getStat(context, key) + 1);
    }

    public int getStat(Context context, String key) {
        return KeyStore.getInstance(context).getInt(key, 0);
    }
}
