package com.pushpole.sdk.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.R;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.device.DeviceIDHelper;
import com.pushpole.sdk.network.ImageDownloader;
import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.task.PushPoleAsyncTask;
import com.pushpole.sdk.task.TaskManager;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 2017-07-08, 2:33 PM.
 *
 * @author Akram Shokri
 */


/**
 * Ask user to grant using read_phone_state permission
 */
public class RequestAccessDialogActivity extends Activity {
    private boolean dialogShowing = false;
    private AlertDialog alertDialog = null;
    private String privacyMsgBody;
    private String privacyMsgTitle;
    private String privacyMsgIcon;
    private String okBtnText;
    private String cancelBtnText;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        try {
            privacyMsgTitle =  getIntent().getStringExtra(Constants.getVal(Constants.ASK_IMEI_DIALOG_TITLE));//ASK_IMEI_DIALOG_TITLE: downstream key used for putting extra
            privacyMsgBody =  getIntent().getStringExtra(Constants.getVal(Constants.ASK_IMEI_DIALOG_CONTENT));//ASK_IMEI_DIALOG_CONTENT: downstream key used for putting extra
            privacyMsgIcon = getIntent().getStringExtra(Constants.getVal(Constants.ASK_IMEI_DIALOG_ICON));
            okBtnText = getIntent().getStringExtra(Constants.getVal(Constants.ASK_IMEI_PRIVACY_OK_BTN_TXT));
            cancelBtnText = getIntent().getStringExtra(Constants.getVal(Constants.ASK_IMEI_PRIVACY_CANCEL_BTN_TXT));
        }catch (Exception e){

        }
        if(!dialogShowing)
            createAndShowDialog();
    }


    /**
     * Create a {@link AlertDialog} asynchronously
     * the dialog contains {@link com.pushpole.sdk.message.downstream.DownstreamMessage} content and close button
     */
    private void createAndShowDialog() {
        final Context context = this;
        TaskManager.getInstance(context).asyncTask(new PushPoleAsyncTask() {
            @Override
            public void run(final Context ctx) {
                final AlertDialog.Builder builder = new AlertDialog.Builder(context);

                builder.setOnCancelListener(new DialogInterface.OnCancelListener() {
                    @Override
                    public void onCancel(DialogInterface dialogInterface) {
                        saveActionAndCloseDialog(-1);
                    }
                });

                ;
                View dialogView = RequestAccessDialogActivity.this.getLayoutInflater().inflate(R.layout.pushpole_custom_dialog, null);
                TextView contentTv = (TextView) dialogView.findViewById(R.id.pushpoleDialogContentTv);
                contentTv.setMovementMethod(new ScrollingMovementMethod());

                if (privacyMsgBody == null || (privacyMsgBody != null && privacyMsgBody.isEmpty())) {
                    return; //if no body is set for dialog, don't show anything
                }
                if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.N)
                    contentTv.setText(Html.fromHtml(privacyMsgBody, Html.FROM_HTML_MODE_COMPACT));
                else
                    contentTv.setText(Html.fromHtml(privacyMsgBody));

                TextView titleTv = (TextView) dialogView.findViewById(R.id.pushpoleDialogTitleTv);
                titleTv.setText(privacyMsgTitle);

                Button okBtn = (Button) dialogView.findViewById(R.id.pushpoleDialogOkBtn);
                okBtn.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        saveActionAndCloseDialog(1);
                    }
                });
                if(okBtnText != null && !okBtnText.isEmpty()){
                    okBtn.setText(okBtnText);
                }

                Button cancelBtn = (Button) dialogView.findViewById(R.id.pushpoleDialogCancelBtn);
                cancelBtn.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        saveActionAndCloseDialog(0);
                    }
                });
                if(cancelBtnText != null && !cancelBtnText.isEmpty()){
                    cancelBtn.setText(cancelBtnText);
                }

                if(privacyMsgIcon != null && !privacyMsgIcon.isEmpty()){
                    ImageDownloader downloader = new ImageDownloader();
                    Bitmap icon = downloader.downloadImage(privacyMsgIcon);
                    if (icon != null){
                        ImageView iv = (ImageView) dialogView.findViewById(R.id.pushpoleDialogIV);
                        iv.setImageBitmap(icon);
                    }
                }

                ImageView closeIV = (ImageView) dialogView.findViewById(R.id.pushpoleCloseIV);
                closeIV.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        saveActionAndCloseDialog(-1); //-1: user closed or dismissed dialog
                    }
                });


                builder.setView(dialogView);

                builder.setCancelable(true);

                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        alertDialog = builder.create();
                        alertDialog.show();
                        dialogShowing = true;
                    }
                });
            }
        });

    }

    private void saveActionAndCloseDialog(int userAccepted){
        //if user already didn't answered to this dialog and now has answered again, update it
        if(KeyStore.getInstance(this).getInt(Constants.getVal(Constants.KEY_STORE_USE_IMEI_USER_ANSWER), -1) >= 0 && userAccepted >= 0) {
            KeyStore.getInstance(this).putInt(Constants.getVal(Constants.KEY_STORE_USE_IMEI_USER_ANSWER), userAccepted);
        } //if user didn't answer this question before, save his answer as is
        else if(KeyStore.getInstance(this).getInt(Constants.getVal(Constants.KEY_STORE_USE_IMEI_USER_ANSWER), -1) < 0){
            KeyStore.getInstance(this).putInt(Constants.getVal(Constants.KEY_STORE_USE_IMEI_USER_ANSWER), userAccepted);
        }
        dialogShowing = false;

        Pack p = new Pack();
        String state = "";
        if(userAccepted == 1) {
            state = Constants.getVal(Constants.USE_IMEI_STATE_ACCEPTED);
            DeviceIDHelper idHelper = new DeviceIDHelper(this);
            String mainSimImei = idHelper.getIMEI();
            if(mainSimImei != null && !mainSimImei.isEmpty())
                p.putString(Constants.getVal(Constants.Info.F_PERMITED_IMEI), mainSimImei);

            String secondSimImei = idHelper.getSecondSimIMEI();
            if(secondSimImei != null && !secondSimImei.isEmpty() && !secondSimImei.equals(mainSimImei))
                p.putString(Constants.getVal(Constants.Info.F_PERMITED_IMEI_2), secondSimImei);
        }
        else if(userAccepted == 0)
            state = Constants.getVal(Constants.USE_IMEI_STATE_DECLINED);
        else
            state = Constants.getVal(Constants.USE_IMEI_STATE_DISMISS);

        p.putString(Constants.getVal(Constants.USE_IMEI_STATE), state);
        SendManager.getInstance(getApplicationContext()).send(Constants.getVal(Constants.ASK_IMEI_PERMISSION_T), p);

        alertDialog.dismiss();

        RequestAccessDialogActivity.this.finish();
    }

}
