package com.pushpole.sdk.util;


import android.app.Notification;
import android.content.Context;
import android.os.Build;

import com.pushpole.sdk.internal.exceptions.NotificationBuildFailed;
import com.pushpole.sdk.message.downstream.NotificationDownstreamMessage;

/***
 * The base class to build notification message
 */
public abstract class NotificationBuilder {

    protected NotificationBuilder() {

    }

    public static NotificationBuilder getBuilder(Context context, NotificationDownstreamMessage message, int notificationId) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            return new NotificationBuilderApi16AndAbove(context, message, notificationId);
        } else {

            return new NotificationBuilderApiBelow16(context, message, notificationId);
        }

    }

    /***
     * Build notification object
     *
     * @return
     * @throws NotificationBuildFailed
     */

    public abstract Notification build() throws NotificationBuildFailed;

}
