package com.pushpole.sdk.topic;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.util.Crypto;
import com.pushpole.sdk.util.Pack;

/***
 * Topic entity
 */
public class Topic {
    private String mCode;
    private String mStatus; //0: add, 1: remove

    /***
     * empty constructor
     */
    public Topic() {

    }

    /***
     * constructor
     *
     * @param code the code
     */
    public Topic(String code) {
        mCode = code;
    }

    public Topic(String code, String status) {
        mCode = code;
        mStatus = status;
    }
    /***
     * get topic code
     *
     * @return the code
     */
    public String getCode() {
        return mCode;
    }

    /***
     * set topic code
     *
     * @param code the code
     */
    public void setCode(String code) {
        mCode = code;
    }

    public String getStatus() {
        return mStatus;
    }

    public void setStatus(String status) {
        this.mStatus = status;
    }

    public Pack toPack(){
        Pack aTopicPack = new Pack();
        aTopicPack.putString(Constants.getVal(Constants.F_PUSHPOLE_TOPIC_CODE), mCode);
        aTopicPack.putString(Constants.getVal(Constants.F_PUSHPOLE_TOPIC_STATUS), mStatus);
        aTopicPack.putString(Constants.getVal(Constants.TIMESTAMP), String.valueOf(System.currentTimeMillis()));
        return aTopicPack;
    }

    public static Topic fromPack(Pack pack) {
        Topic t = new Topic();
        t.setCode(pack.getString(Constants.getVal(Constants.F_PUSHPOLE_TOPIC_CODE), null));
        t.setStatus(pack.getString(Constants.getVal(Constants.F_PUSHPOLE_TOPIC_STATUS), null));
        //no need to retrieve timeStamp
        return t;
    }
}
