package com.pushpole.sdk.task.tasks;

import android.content.Context;

import java.io.IOException;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.FirebaseAppNotAvailableException;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.MessageDirection;
import com.pushpole.sdk.message.MessageStore;
import com.pushpole.sdk.network.UpstreamSender;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.PushPoleTask;
import com.pushpole.sdk.util.Pack;
import com.pushpole.sdk.util.PushPoleFailedException;

/***
 * A class that represent task for sending upstream message
 */
public class UpstreamSendTask implements PushPoleTask {

    /***
     * The runTask contains operations for sending upstream message
     *
     * @param context  the app context
     * @param taskPack the task pack
     * @return * @return {@code RESULT_SUCCESS} or {@code RESULT_RESCHEDULE} or {@code RESULT_FAILURE}
     */
    @Override
    public Result runTask(Context context, Pack taskPack) {
        if (taskPack == null) {
            Logger.warning("No data given to UpstreamSendTask, possibly because of a clean data");
            return Result.FAIL;
        }

        String messageId = taskPack.getString(Constants.getVal(Constants.MESSAGE_ID), null);
        Pack message = null;

        try {
            message = MessageStore.getInstance().getMessagePack(context, messageId);//tODO: ????
        } catch (MessageStore.NoSuchPackException e) {
            Logger.error("Invalid message id given for Upstream Send Task", new LogData(
                    "Message ID", messageId
            ));
            return Result.FAIL;
        }

        if (!MessageDirection.UPSTREAM.name().equals(message.getString(Constants.getVal(Constants.MESSAGE_DIRECTION)))) {
            Logger.debug("Downstream message given for Upstream Send Task");
            return Result.FAIL;
        }

        try {
            new UpstreamSender(context).attemptSend( message);
        } catch (IOException | PushPoleFailedException | FirebaseAppNotAvailableException e) {
            Logger.warning("Sending Upstream Message failed in UpstreamSendTask class- " + e.getLocalizedMessage());
            android.util.Log.e("PushPole", "Sending upstream message failed", e);
            return Result.RESCHEDULE;
        }

        MessageStore.getInstance().deleteMessage(context, messageId);
        return Result.SUCCESS;
    }
}
