package com.pushpole.sdk.task.tasks;

import android.content.Context;

import java.util.List;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.controller.controllers.SubscriptionController;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.PushPoleTask;
import com.pushpole.sdk.topic.Topic;
import com.pushpole.sdk.util.Pack;

/***
 * A class that represent task for subscribing to GCM channel (topic)
 */
public class SubscribeTask implements PushPoleTask {

    /***
     * The runTask contains operations for subscribing to GCM channel (topic)
     *
     * @param context  the app context
     * @param taskPack the task pack
     * @return * @return {@code RESULT_SUCCESS} or {@code RESULT_RESCHEDULE} or {@code RESULT_FAILURE}
     */
    @Override
    public Result runTask(Context context, Pack taskPack) {
        String action = null;
        if(taskPack == null){
            Logger.error("Null task passed to SubscribeTask, task execution aborted.");
            return Result.FAIL;
        }
        try {
            action = taskPack.getString(Constants.getVal(Constants.TASK_ACTION));
        } catch (NumberFormatException e) {
            Logger.warning("No action defined for SubscribeTask");
            action = Constants.getVal(SubscriptionController.SUBSCRIBE);
        }

        SubscriptionController ctrl = new SubscriptionController(context);
        String topicStr = taskPack.getString(Constants.getVal(Constants.TOPICS), null);

        if (topicStr == null) {
            Logger.error("No topic list given for SubscribeTask, aborting task");
            return Result.FAIL;
        }

        List<Topic> topics = ctrl.topicListFromString(topicStr);
        List<Topic> remainingTopics = ctrl.attemptTopicSubscription(action, topics);

        if (remainingTopics.size() == 0) {
            return Result.SUCCESS;
        }

        taskPack.putString(Constants.getVal(Constants.TOPICS), ctrl.topicListToString(remainingTopics));

        return Result.RESCHEDULE;
    }
}
