package com.pushpole.sdk.task.tasks;

import android.content.Context;
import android.util.Log;

import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;

import com.pushpole.sdk.PushPole;
import com.pushpole.sdk.SenderInfo;
import com.pushpole.sdk.controller.controllers.RegisterController;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.PushPoleTask;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.options.DefaultOptions;
import com.pushpole.sdk.task.options.SingletonTask;
import com.pushpole.sdk.util.Pack;

/***
 * A class that represent task for registering GCM
 */
@SingletonTask
@DefaultOptions(persisted = true, network = true, replace = true)
public class FcmRegisterTask implements PushPoleTask {
    static boolean fcmRegistrationPerformed = false;
    /***
     * The runTask contains operations for registering gcm
     *
     * @param context  the app context
     * @param taskPack the task pack
     * @return {@code RESULT_SUCCESS} or {@code RESULT_RESCHEDULE}
     */
    @Override
    public Result runTask(Context context, Pack taskPack) {

        try {
            if (fcmRegistrationPerformed) {
                Logger.debug("Skipping FCM registration");
                return Result.SUCCESS;
            }

            InstanceIdResult result = Tasks.await(FirebaseInstanceId.getInstance(PushPole.getFirebaseApp(context)).getInstanceId());

            if (result == null) {
                return Result.RESCHEDULE;
            }

            String instanceId = result.getId();
            String token = result.getToken();

            if (!token.isEmpty()) {
                SenderInfo senderInfo = SenderInfo.getInstance(context);
                senderInfo.setInstanceId(instanceId);
                try {
                    Logger.info("Firebase Instance Id ready", new LogData(
                            "Instance ID", instanceId,
                            "Sender ID", senderInfo.getSenderId(),
                            "Token", token
                    ));
                } catch (Exception ex) {
                    Logger.error("Failed to get sender id", ex);
                }

                Log.i("PushPole", "Firebase token obtained, starting pushpole registration");
                RegisterController registerController = new RegisterController(context);
                registerController.onGCMRegisterComplete(token);
                fcmRegistrationPerformed = true;
                return Result.SUCCESS;
            }

            Logger.info("Obtaining Firebase token failed, will reschedule to try again");
            Log.w("PushPole", "Obtaining Firebase token failed, rescheduling to try again");
            return Result.RESCHEDULE;
        } catch (Exception e) {
            Logger.warning("Registering FCM failed - " + e.getLocalizedMessage(), new LogData(
                    "Message", e.getMessage()
            ));

            Log.e("PushPole", "Obtaining FCM token failed: " + e.getLocalizedMessage(), e);

            return Result.RESCHEDULE;
        }
    }
}
