package com.pushpole.sdk.task.scheduler.evernote;

import android.content.Context;

import com.evernote.android.job.Job;
import com.evernote.android.job.JobApi;
import com.evernote.android.job.JobConfig;
import com.evernote.android.job.JobCreator;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.JobRequest;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.options.TaskOptions;
import com.pushpole.sdk.task.scheduler.Scheduler;

/**
 * Created by vahid on 7/14/16.
 */
public class EvernoteScheduler implements JobCreator, Scheduler {

    public EvernoteScheduler(Context context) {
        /*JobApi.setForceAllowApi14(true); // to avoid issue#197, see evernote github
        JobManager.create(context);
        JobManager.instance().getConfig().setVerbose(false); //for android-job latest version
        JobManager.instance().getConfig().setGcmApiEnabled(false); // is only important for Android 4.X, to avoid issue#197, see evernote github
        JobManager.instance().addJobCreator(this);*/

        // FIXME using version 1.2.0 of evernote jobe library
         JobManager.create(context);
         JobConfig.setLogcatEnabled(false);
         JobConfig.setForceAllowApi14(true);
         JobConfig.setApiEnabled(JobApi.GCM, false);
         JobManager.instance().addJobCreator(this);
    }

    @Override
    public void schedule(Context context, String tag, TaskOptions taskOptions) {
        //Logger.debug("Schedule tag:" + tag);

//        FIXME Cancelling here?!
//        if (ks.contains(this.getTag())) {
//            int jobId = ks.getInt(this.getTag(), 0);
//            Logger.debug("Send Job canceled id:" + String.valueOf(jobId));
//            JobManager.create(context).cancel(jobId);
//        }

        JobRequest request = null;

        assert taskOptions.getPeriod() != null;

        if (taskOptions.getPeriod() <= 0) {
            request = createOneTimeJob(tag, taskOptions);
        } else {
            request = createPeriodicJob(tag, taskOptions);
        }

        int jobId = request.schedule();
        KeyStore ks = KeyStore.getInstance(context);
        ks.putInt(tag, jobId);
    }

    private JobRequest createOneTimeJob(String tag, TaskOptions options) {
        JobRequest.Builder builder = new JobRequest.Builder(tag);
        setDefaultJobOptions(builder, options);
        builder.setExecutionWindow(options.getDelay() + 1, options.getDelay() + 1 + options.getWindow());
        return builder.build();
    }

    private JobRequest createPeriodicJob(String tag, TaskOptions options) {
        long period = options.getPeriod();
        long maxWindowTime = period / 4;

        Long windowTime = (long) (int) (Math.random() * maxWindowTime);

        JobRequest.Builder builder = new JobRequest.Builder(tag);
        setDefaultJobOptions(builder, options);
        builder.setPeriodic(period + windowTime);
        return builder.build();
    }

    private void setDefaultJobOptions(JobRequest.Builder builder, TaskOptions options) {
        builder.setUpdateCurrent(options.getReplace());
        //builder.setPersisted(options.getPersisted());
        if (options.getRequiresNetwork()) {
            builder.setRequiredNetworkType(JobRequest.NetworkType.CONNECTED);
        } else {
            builder.setRequiredNetworkType(JobRequest.NetworkType.ANY);
        }
    }


    public void cancel(Context context, String tag) {
        KeyStore ks = KeyStore.getInstance(context);
        if (ks.contains(tag)) {
            int jobId = ks.getInt(tag, 0);
            if (jobId > 0) {
                JobManager.create(context).cancel(jobId);
                Logger.debug("Cancel job :" + jobId);
            }
        }

    }

    /**
     * If set immediate true, then send upstream just after scheduling.
     *
     * @param b
     * @param context
     * @param msgTypeCode
     */
    public static void setImmediate(Boolean b, Context context, String msgTypeCode) {
        KeyStore ks = KeyStore.getInstance(context);
        StringBuilder sb = new StringBuilder();
        sb.append(Constants.getVal(Constants.IMMEDIATE))
                .append('_')
                .append(msgTypeCode);
        ks.putBoolean(sb.toString(), b);
    }

    /***
     * If set immediate true, then send upstream just after scheduling.
     *
     * @param context
     * @param msgTypeCode
     * @return
     */
    public static Boolean isImmediate(Context context, String msgTypeCode) {
        KeyStore ks = KeyStore.getInstance(context);
        StringBuilder sb = new StringBuilder();
        sb.append(Constants.getVal(Constants.IMMEDIATE))
                .append('_')
                .append(msgTypeCode);
        return ks.getBoolean(sb.toString(), false);
    }

    /**
     * Create Job object by default constructor.
     * Evernote need this method
     *
     * @param tag
     * @return
     */
    @Override
    public Job create(String tag) {
        return new EvernoteJobAdapter(tag);
    }
}

