package com.pushpole.sdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.Logger;

/**
 * Created on 16-08-20, 10:46 AM.
 *
 * @author Akram Shokri
 */
public class PushPoleAppExistsReceiver extends BroadcastReceiver{

    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals(Constants.getVal(Constants.NOTIFY_OTHER_PUSHPOLE_APP_INTENT_ACTION))){
            String senderPackageName = intent.getStringExtra(Constants.getVal(Constants.NOTIFY_OTHER_APP_CALLER_PACKAGE));

            //excluding sender from reacting to broadcast that it has sent
            if (senderPackageName != null && !senderPackageName.equals(context.getPackageName())) {
                Logger.debug("PushPoleAppExistsReceiver invoked ...");
                KeyStore.getInstance(context).putLong(Constants.getVal(Constants.LAST_SEND_UPSTREAM_TIME), System.currentTimeMillis());
            }
        }
    }
}
