package com.pushpole.sdk.message.upstream;

import java.util.ArrayList;
import java.util.List;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-05-28, 2:15 PM.
 *
 * @author Akram Shokri
 */
//TODO: This class is not tested yet
public class WifiNetworksUpstreamMessage extends UpstreamMessage {
    private List<Pack> mWifiNetworks;

    @Override
    public Type getMessageType() {
        return Type.WIFI_LIST;
    }

    public void setWifiNetworks(List<Pack> wifiList) {
        this.mWifiNetworks = wifiList;
    }

    public List<Pack> getWifiNetworks() {
        return mWifiNetworks;
    }

    @Override
    public Pack toPack() {
        ListPack wifisPack = new ListPack();

        if (mWifiNetworks != null) {
            for ( int i = 0; i < mWifiNetworks.size(); i++) {
                wifisPack.addPack(i, mWifiNetworks.get(i));
            }
        }

        Pack pack = super.toPack();
        pack.putListPack(Constants.getVal(Constants.WIFI_LIST_T), wifisPack);

        return pack;
    }

    public static class Factory extends UpstreamMessageFactory {

        @Override
        public UpstreamMessage buildMessage(Pack data) {// TODO: this method is used in its relevant upstream task, not tested yet @AK
            WifiNetworksUpstreamMessage message = new WifiNetworksUpstreamMessage();
            populateMessage(message, data);

            ListPack wifiha = data.getListPack(Constants.getVal(Constants.WIFI_LIST_T), null);
            if (wifiha != null) {
                List<Pack> wifiList = new ArrayList<>();
                for (int i = 0; i< wifiha.size(); i++) {
                    Pack tPack = wifiha.getPack(i);
                    wifiList.add(tPack);
                }

                message.setWifiNetworks(wifiList);
            }
            return message;
        }

        public WifiNetworksUpstreamMessage buildMessage(ListPack wifiList){
            WifiNetworksUpstreamMessage message = new WifiNetworksUpstreamMessage();
            populateMessage(message);
            if(message.mWifiNetworks == null)
                message.mWifiNetworks = new ArrayList<>();
            for(int i = 0; i < wifiList.size(); i++){
                message.mWifiNetworks.add(wifiList.getPack(i));//TODO: null pointer exception
            }
            return message;
        }
    }
}
