package com.pushpole.sdk.internal.log;

import android.os.Bundle;
import android.os.Parcel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LogData implements Iterable<String> {
    private Bundle mBundle;

    public LogData() {
    }

    public LogData(String... params) {
        this();
        for (int i = 0; i < (params.length / 2) * 2; i += 2) {
            put(params[i], params[i + 1]);
        }
    }

    public LogData(byte[] data) {
        this();
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(data, 0, data.length);
        parcel.setDataPosition(0);
        mBundle = parcel.readBundle();
        parcel.recycle();
    }

    public void put(String key, String value) {
        getBundle().putString(key, value);
    }

    public String get(String key) {
        return getBundle().getString(key);
    }

    private Bundle getBundle() {
        if (mBundle == null) {
            mBundle = new Bundle();
        }
        return mBundle;
    }

    public byte[] toBytes() {
        Parcel parcel = Parcel.obtain();
        getBundle().writeToParcel(parcel, 0);
        byte[] data = parcel.marshall();
        parcel.recycle();
        return data;
    }

    public Map<String, String> toMap() {
        Map<String, String> map = new HashMap<>();
        for (String key : getBundle().keySet()) {
            map.put(key, mBundle.getString(key));
        }
        return map;
    }

    public int size() {
        if (mBundle == null) {
            return 0;
        }
        return mBundle.size();
    }

    @Override
    public Iterator<String> iterator() {
        return getBundle().keySet().iterator();
    }
}
