package com.pushpole.sdk.internal;

import android.content.Context;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-06-28, 10:24 AM.
 * A class to contain all save to DB operation related to collecting info and usages stats from device
 *
 * @author Akram Shokri
 */
public class ClientInitiatedEventHandler {
    public static void saveBootInfo(Context context) {
        //collection Time is equal to reboot time. this task is not schedule-able
        String jsonData = String.valueOf(System.currentTimeMillis());

        SendManager.getInstance(context).send(Constants.getVal(Constants.DEVICE_BOOT_T), jsonData);
        Logger.debug("Inserting boot event time in ScheduledData DB", new LogData("data", jsonData));
    }

    public static void saveScreenOnOffInfo(Context context, Pack jsonData) {
        SendManager.getInstance(context).send(Constants.getVal(Constants.SCREEN_ON_OFF_T), jsonData);
        Logger.debug("Inserting screen On/Off time in ScheduledData DB", new LogData("data", jsonData.toJson()));
    }

    public static void saveOpenAppTime(Context context) {
        SendManager.getInstance(context).send(Constants.getVal(Constants.OPEN_APP_T), String.valueOf(System.currentTimeMillis()));
        Logger.debug("OpenApp data inserted in ScheduledData DB", new LogData("data", String.valueOf(System.currentTimeMillis())));
    }
}
