package com.pushpole.sdk.fcm;

import android.content.Context;

import com.google.firebase.messaging.RemoteMessage;

public class FcmHandler {
    private FcmHandlerImpl fcmHandlerImpl;

    public FcmHandler(Context context) {
        this.fcmHandlerImpl = new FcmHandlerImpl(context);
    }

    public void onNewToken(String token) {
        fcmHandlerImpl.onNewToken(token);
    }

    public boolean onMessageReceived(RemoteMessage remoteMessage) {
        return fcmHandlerImpl.onMessageReceived(remoteMessage);
    }

    public void onDeletedMessages() {
        fcmHandlerImpl.onDeletedMessages();
    }

    public void onMessageSent(String msgId) {
        fcmHandlerImpl.onMessageSent(msgId);
    }

    public void onSendError(String msgId, Exception error) {
        fcmHandlerImpl.onSendError(msgId, error);
    }
}
