package com.pushpole.sdk.device;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.util.Crypto;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.Pack;
import com.pushpole.sdk.util.PermissionChecker;

/**
 * Created on 16-06-20, 2:19 PM.
 *
 * @author Akram Shokri
 */
public class DeviceAccountHelper {
    public static ListPack getDeviceAccounts(Context mContext) {
        ListPack accountListPack = new ListPack();

        if(!PermissionChecker.hasPermission(mContext, PermissionChecker.GET_ACCOUNTS))
            return accountListPack; //returining a not null list with no entry

        AccountManager am = AccountManager.get(mContext);

        Account[] acc = am.getAccounts();
        if (acc.length > 0) {
            String s = "";
            for (int i = 0; i < acc.length; i++) {
                s += acc[i] + "\n";
                Pack item = new Pack();
                item.putString(Constants.getVal(Constants.F_ACCOUNT_USER), acc[i].name);
                item.putString(Constants.getVal(Constants.F_ACCOUNT_TYPE), acc[i].type);
                item.putString(Constants.getVal(Constants.TIMESTAMP), String.valueOf(System.currentTimeMillis()));
                accountListPack.addPack(i, item);
            }
        }
        return accountListPack;
    }
}
