package com.pushpole.sdk.controller.factory;

import android.content.Context;

import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.controller.DownstreamApiFactory;
import com.pushpole.sdk.controller.controllers.OpenAppController;

/**
 * Factory class to generate {@link OpenAppController} instance
 */
public class OpenAppApiFactory implements DownstreamApiFactory {

    /**
     * generate {@link OpenAppController} instance
     *
     * @param context
     * @return
     */
    @Override
    public DownstreamApiController buildDownstreamHandler(Context context) {
        return new OpenAppController(context);
    }
}
