package com.pushpole.sdk.controller.controllers;

import android.content.Context;

import com.pushpole.sdk.internal.ClientInitiatedEventHandler;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.message.downstream.DownstreamMessage;


public class OpenAppController implements DownstreamApiController {
    public final static String KEY_LAST_OPEN_APP_SEND = "$last_open_app_send";

    private Context mContext;

    public OpenAppController(Context context) {
        mContext = context;
    }


    /**
     * handler for query location downstream message
     * get new location and send it as upstream message to push-server
     *
     * @param message downstream message
     */
    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        //Query Location command in pushpole v 1.0.0 + is not required and replaced by floating command
        /*LocationMessage locMessage = new LocationMessage.Factory().buildMessage(mContext, false);
        new UpstreamSender(mContext).sendMessage(locMessage);*/
    }

    /**
     * This method should be called every time application is opened (onStart).
     * It sends a location message to the server but doesn't send messages with a rate higher than
     * once every fifteen minutes.
     * <p>
     * This method operates synchronously.
     */
    public void onOpenApp() {
        ClientInitiatedEventHandler.saveOpenAppTime(mContext);
    }

}
