package com.pushpole.sdk.controller.controllers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.message.downstream.NotifAndDeviceEventsOnOffMessage;
import com.pushpole.sdk.receiver.AppChangeReceiver;
import com.pushpole.sdk.receiver.BootAndScreenReceiver;
import com.pushpole.sdk.receiver.ConnectivityReceiver;
import com.pushpole.sdk.service.ScreenStateService;

/**
 * Created on 2017-05-23, 12:01 PM.
 *
 * @author Akram Shokri
 */

public class NotifAndDeviceEventsOnOffController implements DownstreamApiController {
    private Context mContext;

    public NotifAndDeviceEventsOnOffController(Context mContext) {
        this.mContext = mContext;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        NotifAndDeviceEventsOnOffMessage onOffCmdMessage = (NotifAndDeviceEventsOnOffMessage) message;
        if (onOffCmdMessage.isSetNotifOff())
            KeyStore.getInstance(mContext).putBoolean(Constants.getVal(Constants.NOTIFICATION_OFF), true);
        else if (onOffCmdMessage.isSetNotifOn())
            KeyStore.getInstance(mContext).putBoolean(Constants.getVal(Constants.NOTIFICATION_OFF), false);

        //save a key in keystore to be used in PushPole.initialize
        if (onOffCmdMessage.isScreenServiceOff()) {
            Logger.debug("Stopping screen state service");
            KeyStore.getInstance(mContext).putBoolean(Constants.getVal(Constants.STOP_SCREEN_SERVICE_KEY_STORE), true);
            mContext.stopService(new Intent(mContext, ScreenStateService.class));
        } else if (onOffCmdMessage.isScreenServiceOn()) {
            Logger.debug("Starting screen state service");
            KeyStore.getInstance(mContext).putBoolean(Constants.getVal(Constants.STOP_SCREEN_SERVICE_KEY_STORE), false);
            mContext.startService(new Intent(mContext, ScreenStateService.class));
        }

        if (onOffCmdMessage.isAppChangeReceiverOff()) {
            changeComponentState(new ComponentName(mContext,
                    AppChangeReceiver.class.getName()), true);
        } else if (onOffCmdMessage.isAppChangeReceiverOn()) {
            changeComponentState(new ComponentName(mContext,
                    AppChangeReceiver.class.getName()), false);
        }

        if (onOffCmdMessage.isBootReceiverOff()) {
            changeComponentState(new ComponentName(mContext,
                    BootAndScreenReceiver.class.getName()), true);
        } else if (onOffCmdMessage.isBootReceiverOn()) {
            changeComponentState(new ComponentName(mContext,
                    BootAndScreenReceiver.class.getName()), false);
        }

        if (onOffCmdMessage.isConnectivityReceiverOff()) {
            Logger.debug("Connectivity state is set to Off");
            KeyStore.getInstance(mContext).putBoolean(Constants.STOP_CONNECTIVITY_KEY_STORE, true);
            changeComponentState(new ComponentName(mContext, ConnectivityReceiver.class.getName()), true);
        } else if (onOffCmdMessage.isConnectivityReceiverOn()) {
            Logger.debug("Connectivity state is set to On");
            KeyStore.getInstance(mContext).putBoolean(Constants.STOP_CONNECTIVITY_KEY_STORE, false);
            changeComponentState(new ComponentName(mContext, ConnectivityReceiver.class.getName()), false);
        }
    }

    private void changeComponentState(ComponentName component, boolean disable) {
        if (disable) {
            mContext.getPackageManager().setComponentEnabledSetting(component,
                    PackageManager.COMPONENT_ENABLED_STATE_DISABLED, PackageManager.DONT_KILL_APP);
            Logger.debug(component.getClassName() + " disabled");
        } else {
            mContext.getPackageManager().setComponentEnabledSetting(component,
                    PackageManager.COMPONENT_ENABLED_STATE_ENABLED, PackageManager.DONT_KILL_APP);
            Logger.debug(component.getClassName() + " enabled");
        }
    }
}
