package com.pushpole.sdk.controller.controllers;

import android.content.Context;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.downstream.ConnectivityInfoMessage;
import com.pushpole.sdk.message.downstream.DownstreamMessage;

/**
 * Created on 2017-04-18, 9:46 AM.
 *
 * @author Akram Shokri
 */

public class ConnectivityInfoController implements DownstreamApiController {
    private Context mContext;

    public ConnectivityInfoController(Context context) {
        mContext = context;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        Logger.info("Downstream message connectivityInfo");
        ConnectivityInfoMessage connectivityMsg = (ConnectivityInfoMessage) message;
        KeyStore.getInstance(mContext).putInt(Constants.getVal(Constants.KEY_STORE_CONNECTED_NETWORK_THRESHOLD), connectivityMsg.getThreshold());
    }
}
