package com.pushpole.sdk.controller.controllers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;

import java.util.List;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.device.DeviceApplicationHelper;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 2017-11-07, 5:45 PM.
 *
 * @author Akram Shokri
 */

public class CheckHiddenAppController implements DownstreamApiController {

    private Context mContext;

    public CheckHiddenAppController(Context mContext) {
        this.mContext = mContext;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        SendManager.getInstance(mContext).send(Constants.getVal(Constants.CHECK_IS_HIDDEN_APP_T), hiddenAppPack());//TODO: don't send if false??
    }

    public Pack hiddenAppPack(){
        Pack hideAppPack = new Pack();
        hideAppPack.putBool(Constants.getVal(Constants.APP_IS_HIDDEN), new DeviceApplicationHelper(mContext).isAppHidden(mContext.getPackageName()));
        return hideAppPack;
    }
}
