package com.pushpole.sdk.controller;

import android.content.Context;

/**
 * Factory class to generate {ResponseApiController} instance
 * When creating a new {@link ResponseApiFactory}, implement this class to create instances of your {@link ResponseApiController}
 */
public interface ResponseApiFactory {
    /**
     * Builds an {@link ResponseApiController} instance .
     * <p>
     * Override this method to create instances of your {@link ResponseApiController}.
     *
     * @param context the app context
     * @return the new instance of the {@link ResponseApiController}
     */
    ResponseApiController buildResponseApiHandler(Context context);
}
