package com.pushpole.sdk.collection.tasks;

import android.content.Context;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.device.DeviceApplicationHelper;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.options.DefaultOptions;
import com.pushpole.sdk.task.options.SingletonTask;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 2017-11-07, 5:57 PM.
 *
 * @author Akram Shokri
 */

@SingletonTask
@DefaultOptions(period = 3 * 24 * 60 * 60 * 1000) //default schedule: 3 days
public class CheckIsHiddenAppTask extends CollectionTask{
    @Override
    public Result runTask(Context context, Pack taskPack) {
        Logger.info("Checking hidden app task");
        boolean prevHiddenState = KeyStore.getInstance(context).getBoolean(PlainConstants.KEYSTORE_HIDDEN_APP_KEY, false);
        boolean currentHiddenState = new DeviceApplicationHelper(context).isAppHidden(context.getPackageName());
        if(currentHiddenState != prevHiddenState){
            Pack hideAppPack = new Pack();
            hideAppPack.putBool(Constants.getVal(Constants.APP_IS_HIDDEN), currentHiddenState);
            this.processResult(context, hideAppPack, Constants.getVal(Constants.CHECK_IS_HIDDEN_APP_T));
            KeyStore.getInstance(context).putBoolean(PlainConstants.KEYSTORE_HIDDEN_APP_KEY, currentHiddenState);
        }
        return Result.SUCCESS;
    }
}
