package com.pushpole.sdk.util;


import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;

/***
 * A helper class to for checking permission that has been granted or not
 */
public class PermissionChecker {
    public final static String ACCESS_NETWORK_STATE = Manifest.permission.ACCESS_NETWORK_STATE;
    public final static String READ_PHONE_STATE = Manifest.permission.READ_PHONE_STATE;
    public final static String ACCESS_COURSE_LOCATION = Manifest.permission.ACCESS_COARSE_LOCATION;
    public final static String ACCESS_FINE_LOCATION = Manifest.permission.ACCESS_FINE_LOCATION;
    public final static String ACCESS_WIFI_STATE = Manifest.permission.ACCESS_WIFI_STATE;
    public final static String GET_ACCOUNTS = Manifest.permission.GET_ACCOUNTS;
    public final static String ACTIVITY_RECOGNITION = "com.google.android.gms.permission.ACTIVITY_RECOGNITION";


    /***
     * check permission has granted or not
     *
     * @param context    the app context
     * @param permission desired permission
     * @return true if permission has granted
     */
    public static boolean hasPermission(Context context, String permission) {
        int res = context.checkCallingOrSelfPermission(permission);
        return (res == PackageManager.PERMISSION_GRANTED);
    }
}
