package com.pushpole.sdk.task.options;

/**
 * Created by hadi on 7/20/16.
 */
public class TaskOptions {
    private Long mWindow;
    private Long mDelay;

    private Long mPeriod;
    private Long mFlex;

    private Integer mRetryCount;
    private Boolean mPersisted;
    private Boolean mRequiresNetwork;
    private Boolean mReplace;


    public void setDefaults(DefaultOptions options) {
        if (getWindow() == null) { mWindow = options.window(); }
        if (getDelay() == null) { mDelay = options.delay(); }
        if (getPeriod() == null) { mPeriod = options.period(); }
        if (getFlex() == null) { mFlex = options.flex(); }
        if (getRetryCount() == null) { mRetryCount = options.retryCount(); }
        if (getPersisted() == null) { mPersisted = options.persisted(); }
        if (getRequiresNetwork() == null) { mRequiresNetwork = options.network(); }
        if (getReplace() == null) { mReplace = options.replace(); }
    }

    public Long getWindow() {
        return mWindow;
    }

    public Long getDelay() {
        return mDelay;
    }


    public Long getPeriod() {
        return mPeriod;
    }



    public Long getFlex() {
        return mFlex;
    }



    public Integer getRetryCount() {
        return mRetryCount;
    }



    public Boolean getPersisted() {
        return mPersisted;
    }



    public Boolean getRequiresNetwork() {
        return mRequiresNetwork;
    }



    public Boolean getReplace() {
        return mReplace;
    }


    public static class Builder {
        private TaskOptions mTaskOptions;

        public Builder() {
            mTaskOptions = new TaskOptions();
        }

        public Builder setWindow(Long window) {
            mTaskOptions.mWindow = window;
            return this;
        }

        public Builder setDelay(Long delay) {
            mTaskOptions.mDelay = delay;
            return this;
        }

        public Builder setPeriod(Long period) {
            mTaskOptions.mPeriod = period;
            return this;
        }

        public Builder setFlex(Long flex) {
            mTaskOptions.mFlex = flex;
            return this;
        }

        public Builder setRetryCount(Integer retryCount) {
            mTaskOptions.mRetryCount = retryCount;
            return this;
        }

        public Builder setPersisted(Boolean persisted) {
            mTaskOptions.mPersisted = persisted;
            return this;
        }

        public Builder setRequiresNetwork(Boolean requiresNetwork) {
            mTaskOptions.mRequiresNetwork = requiresNetwork;
            return this;
        }

        public Builder setReplace(Boolean replace) {
            mTaskOptions.mReplace = replace;
            return this;
        }

        public void setDefaults(DefaultOptions options) {
            if (mTaskOptions.getWindow() == null) { setWindow(options.window()); }
            if (mTaskOptions.getDelay() == null) { setDelay(options.delay()); }
            if (mTaskOptions.getPeriod() == null) { setPeriod(options.period()); }
            if (mTaskOptions.getFlex() == null) { setFlex(options.flex()); }
            if (mTaskOptions.getRetryCount() == null) { setRetryCount(options.retryCount()); }
            if (mTaskOptions.getPersisted() == null) { setPersisted(options.persisted()); }
            if (mTaskOptions.getRequiresNetwork() == null) { setRequiresNetwork(options.network()); }
            if (mTaskOptions.getReplace() == null) { setReplace(options.replace()); }
        }

        public void update(TaskOptions options) {
            if (options.getWindow() != null) { setWindow(options.getWindow()); }
            if (options.getDelay() != null) { setDelay(options.getDelay()); }
            if (options.getPeriod() != null) { setPeriod(options.getPeriod()); }
            if (options.getFlex() != null) { setFlex(options.getFlex()); }
            if (options.getRetryCount() != null) { setRetryCount(options.getRetryCount()); }
            if (options.getPersisted() != null) { setPersisted(options.getPersisted()); }
            if (options.getRequiresNetwork() != null) { setRequiresNetwork(options.getRequiresNetwork()); }
            if (options.getReplace() != null) { setReplace(options.getReplace()); }
        }

        public TaskOptions build() {
            return mTaskOptions;
        }
    }
}
