package com.pushpole.sdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.device.ApplicationDetails;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-11-15, 12:26 PM.
 *
 * @author Akram Shokri
 */
public class AppChangeReceiver extends BroadcastReceiver {
    private final String actionAdd1 = "android.intent.action.PACKAGE_INSTALL";
    private final String actionAdd2 = "android.intent.action.PACKAGE_ADDED";
    private final String actionRemove = "android.intent.action.PACKAGE_REMOVED";
    private final String actionFullRemove = "android.intent.action.PACKAGE_FULLY_REMOVED";

    @Override
    public void onReceive(Context context, Intent intent) {

        Uri intentData = intent.getData();
        if (intentData == null) return;

        String packageName = intentData.getEncodedSchemeSpecificPart();
        if (actionAdd1.equals(intent.getAction()) || actionAdd2.equals(intent.getAction())) {
            try {
                PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0);
                ApplicationDetails app = new ApplicationDetails();
                app.setPackageName(info.packageName);
                app.setVersion(info.versionName);
                app.setFirstInstallTime(info.firstInstallTime);
                app.setLastUpdateTime(info.lastUpdateTime);
                app.setAppName(String.valueOf(info.applicationInfo.nonLocalizedLabel));
                try {
                    app.setInstallerPackageName(context.getPackageManager().getInstallerPackageName(info.packageName));
                } catch (IllegalArgumentException e) {
                    Logger.warning("get installer of " + intent.getAction() + " action failed.", new LogData("packageName", packageName));
                }
                SendManager.getInstance(context).send(Constants.getVal(Constants.APP_INSTALL_T), app.toPack()); //TODO: test
            } catch (PackageManager.NameNotFoundException e) {
                Logger.warning("get installed package info of " + intent.getAction() + " action failed.", new LogData("packageName", packageName));
            }
        } else if (actionFullRemove.equals(intent.getAction())) {
            Pack p = new Pack();
            p.putString(Constants.getVal(Constants.TIMESTAMP), String.valueOf(System.currentTimeMillis()));
            p.putString(Constants.getVal(Constants.F_APP_PACKAGENAME), packageName);
            SendManager.getInstance(context).send(Constants.getVal(Constants.APP_UNINSTALL_T), p);
        }

    }
}
