package com.pushpole.sdk.message.downstream;

import com.pushpole.sdk.util.Pack;

/***
 * A class that represent downstream message for sync applications
 */
public class SyncApplicationsDownstreamMessage extends DownstreamMessage {

    /***
     * return message type
     *
     * @return {@code Type.SYNC_APPS}
     */
    @Override
    public DownstreamMessage.Type getMessageType() {
        return Type.SYNC_APPS;
    }

    /***
     * Factory class for generating {@link SyncApplicationsDownstreamMessage} instance
     */
    public static class Factory extends DownstreamMessageFactory {

        /***
         * generate {@link SyncApplicationsDownstreamMessage} instance
         *
         * @param data the data
         * @return {@link SyncApplicationsDownstreamMessage} instance
         */
        @Override
        public DownstreamMessage buildMessage(Pack data) {
            return new SyncApplicationsDownstreamMessage();
        }
    }
}
