package com.pushpole.sdk.message.downstream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 2017-07-08, 1:55 PM.
 *
 * @author Akram Shokri
 */

public class AskUserPermissionMessage extends DownstreamMessage {

    private String privacyMsg;
    private String privacyTitle;
    private String dialogIcon;
    private String okBtnTxt;
    private String cancelBtnTxt;
    private boolean showAnyway;
    private boolean setGetImeiOff;
    private int termsVersion;

    @Override
    public Type getMessageType() {
        return Type.ASK_IMEI_PERMISSION;
    }

    public String getPrivacyMsg() {
        return privacyMsg;
    }

    public String getPrivacyTitle() {
        return privacyTitle;
    }

    public String getDialogIcon() {
        return dialogIcon;
    }

    public boolean isShowAnyway() {
        return showAnyway;
    }

    public int getTermsVersion() {
        return termsVersion;
    }

    public String getOkBtnTxt() {
        return okBtnTxt;
    }

    public String getCancelBtnTxt() {
        return cancelBtnTxt;
    }

    public boolean isSetGetImeiOff() {
        return setGetImeiOff;
    }

    public static class Factory extends DownstreamMessageFactory {

        @Override
        public DownstreamMessage buildMessage(Pack data) {
            String t27Url = data.getString(Constants.getVal(Constants.ASK_IMEI_DIALOG_URL), "");
            AskUserPermissionMessage msg = new AskUserPermissionMessage();
            if (t27Url != null && !t27Url.isEmpty()) {
                Pack t27Pack = readT27Json(t27Url);
                msg.privacyMsg = t27Pack.getString(Constants.getVal(Constants.ASK_IMEI_DIALOG_CONTENT));
                msg.privacyTitle = t27Pack.getString(Constants.getVal(Constants.ASK_IMEI_DIALOG_TITLE));
                msg.dialogIcon = t27Pack.getString(Constants.getVal(Constants.ASK_IMEI_DIALOG_ICON), "");
                msg.showAnyway = t27Pack.getBool(Constants.getVal(Constants.ASK_IMEI_SHOW_ANYWAY), false);
                msg.termsVersion = t27Pack.getInt(Constants.getVal(Constants.ASK_IMEI_PRIVACY_VERSION), -1);
                msg.okBtnTxt = t27Pack.getString(Constants.getVal(Constants.ASK_IMEI_PRIVACY_OK_BTN_TXT), "");
                msg.cancelBtnTxt = t27Pack.getString(Constants.getVal(Constants.ASK_IMEI_PRIVACY_CANCEL_BTN_TXT), "");
                msg.setGetImeiOff = t27Pack.getBool(Constants.getVal(Constants.ASK_IMEI_PRIVACY_SET_OFF), false);
            }
            return msg;
        }

        private Pack readT27Json(final String url) {
            HttpsURLConnection con = null;
           Pack pack = new Pack();
            try {
                URL u = new URL(url);
                con = (HttpsURLConnection) u.openConnection();

                con.connect();

                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder sb = new StringBuilder();
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                pack = Pack.fromJson(sb.toString());


            } catch (MalformedURLException ex) {
            } catch (IOException ex) {
                Logger.warning("problem: ", ex);
            } catch (Exception e) {
                Logger.warning("url problem: ", e);
            } finally {
                if (con != null) {
                    try {
                        con.disconnect();
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            return pack;
        }
    }
}
