package com.pushpole.sdk.internal.log.handlers;

import com.pushpole.sdk.internal.log.Log;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.LogHandler;
import com.pushpole.sdk.util.Pack;

/***
 * This class is registered to Logger.register using log_handlers.json file
 * This class is loaded by reflection and its constructor is called at runtime.
 * Do not mistaken by considering it an unused class.
 */
public class LogcatLogHandler implements LogHandler {

    public LogcatLogHandler() {

    }

    @Override
    public void onLog(Log log) {
        switch (log.getLogLevel()) {
            case DEBUG:
                android.util.Log.d("PushPole", log.getFormatedMessage() + "\n" + getLogData(log.getLogData()));
                break;
            case INFO:
                android.util.Log.i("PushPole", log.getFormatedMessage() + "\n" + getLogData(log.getLogData()));
                break;
            case WARN:
                android.util.Log.w("PushPole", log.getFormatedMessage() + "\n" + getLogData(log.getLogData()));
                break;
            case ERROR:
                android.util.Log.e("PushPole", log.getFormatedMessage() + "\n" + getLogData(log.getLogData()));
                break;
            case FATAL:
                android.util.Log.wtf("PushPole", log.getFormatedMessage(), log.getException());
                break;
            default:
                android.util.Log.e("PushPole", " LogcatLogHandler(): logLevel is not valid:" + log.getLogLevel() , log.getException());
                break;
        }
    }

    private String getLogData(LogData data) {
        if (data == null) {
            return "";
        }
        Pack pack = new Pack();
        for (String key : data.toMap().keySet()) {
            pack.putString(key, data.get(key));
        }
        return pack.toJson();
    }
}
