package com.pushpole.sdk.controller.factory;

import android.content.Context;

import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.controller.DownstreamApiFactory;
import com.pushpole.sdk.controller.ResponseApiController;
import com.pushpole.sdk.controller.ResponseApiFactory;
import com.pushpole.sdk.controller.controllers.SyncApplicationsController;

/**
 * Factory class to generate {@link SyncApplicationsController} instance
 */
public class SyncApplicationsApiFactory implements DownstreamApiFactory, ResponseApiFactory {

    /**
     * generate {@link SyncApplicationsController} instance
     *
     * @param context
     * @return
     */
    @Override
    public DownstreamApiController buildDownstreamHandler(Context context) {
        return new SyncApplicationsController(context);
    }

    /**
     * generate {@link SyncApplicationsController} instance
     *
     * @param context
     * @return
     */
    @Override
    public ResponseApiController buildResponseApiHandler(Context context) {
        return new SyncApplicationsController(context);
    }
}
