package com.pushpole.sdk.controller.controllers;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;


import com.google.android.gms.ads.identifier.AdvertisingIdClient;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.GooglePlayServicesHelper;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.PushPoleInfo;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.device.DeviceApplicationHelper;
import com.pushpole.sdk.device.DeviceIDHelper;
import com.pushpole.sdk.device.DeviceInfoHelper;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.message.upstream.UpstreamMessageFactory;
import com.pushpole.sdk.network.UpstreamSender;
import com.pushpole.sdk.task.PushPoleAsyncTask;
import com.pushpole.sdk.task.TaskManager;
import com.pushpole.sdk.util.ListPack;
import com.pushpole.sdk.util.NetworkHelper;
import com.pushpole.sdk.util.Pack;
import com.pushpole.sdk.Constants.Info;

/**
 * Created on 16-07-05, 12:17 PM.
 *
 * @author Akram Shokri
 */
public class VariableDeviceDataController implements DownstreamApiController {
    private Context mContext;

    public VariableDeviceDataController(Context mContext) {
        this.mContext = mContext;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        sendVariableData();
    }

    public Pack getVariableData() {
        DeviceInfoHelper deviceInfoHelper = new DeviceInfoHelper(mContext);

        Pack devicePack = new Pack();
        devicePack.putString(Constants.getVal(Info.F_OS_VERSION), deviceInfoHelper.getOSVersion());

        PackageInfo pInfo = null;
        try {
            pInfo = mContext.getPackageManager().getPackageInfo(mContext.getPackageName(), 0);
            devicePack.putString(Constants.getVal(Info.F_APP_VERSION), pInfo.versionName);
            devicePack.putInt(Constants.getVal(Info.F_APP_VERSION_CODE), pInfo.versionCode);
        } catch (PackageManager.NameNotFoundException e) {
            Logger.warning("Getting application version failed");
        }

        devicePack.putString(PlainConstants.F_PUSHPOLE_VERSION, PushPoleInfo.VERSION_NAME);
        devicePack.putInt(Constants.getVal(Info.F_PUSHPOLE_VERSION_CODE), PushPoleInfo.VERSION_CODE);


        devicePack.putString(Constants.getVal(Info.F_GOOGLE_PLAY_SERVICES_VERSION), GooglePlayServicesHelper.getGooglePlayServicesVersionName(mContext));
        devicePack.putString(Constants.getVal(Info.F_OPERATOR), NetworkHelper.getOperatorName(mContext));
        String secondOp = NetworkHelper.getSecondOperatorName(mContext);
        if(secondOp != null && !secondOp.isEmpty())
            devicePack.putString(Constants.getVal(Info.F_OPERATOR_2), NetworkHelper.getSecondOperatorName(mContext));

        DeviceApplicationHelper deviceApplicationHelper = new DeviceApplicationHelper(mContext);
        String installer = deviceApplicationHelper.getInstallerPackageName();
        if (installer != null) {
            devicePack.putString(Constants.getVal(Info.F_INSTALLER), installer);
        } else {
            devicePack.putString(Constants.getVal(Info.F_INSTALLER), Constants.getVal(Info.F_INSTALLER_NAME_DIRECT));
        }
        String advertisingId = "";
        try {
            advertisingId = DeviceIDHelper.getAdvertisingId(mContext);
        } catch (Exception e) {
        }
        if(!advertisingId.isEmpty())
            devicePack.putString(Constants.getVal(Info.ADVERTISING_ID), advertisingId);

        devicePack.putString(Constants.getVal(Constants.TIMESTAMP), String.valueOf(System.currentTimeMillis()));

        return devicePack;
    }

    private void sendVariableData() {
        ListPack listPack = new ListPack();
        listPack.addPack(this.getVariableData());

        final Pack upstreamPack = new Pack();
        upstreamPack.putListPack(Constants.getVal(Constants.VARIABLE_DATA_T), listPack);
        upstreamPack.putString(Constants.getVal(Constants.getVal(Constants.F_MESSAGE_ID)), UpstreamMessageFactory.generateMsgId());

        TaskManager.getInstance(mContext).asyncTask(new PushPoleAsyncTask() {
            @Override
            public void run(Context context) {
                new UpstreamSender(context).sendMessage(upstreamPack);
            }
        });
    }
}
