package com.pushpole.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.R;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.util.Pack;

import static com.pushpole.sdk.util.Utility.isValidWebUrl;

/**
 * Created on 16-07-04, 2:53 PM.
 *
 * @author Akram Shokri
 */
public class WebviewActivity extends Activity {
    private String url;
    private String originalMsgId;

    private WebView mWebView;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        //mData = PackBundler.bundleToPack(getIntent().getExtras());
        url = getIntent().getStringExtra(Constants.getVal(Constants.WEBVIEW_URL));
        originalMsgId = getIntent().getStringExtra(Constants.getVal(Constants.WEBVIEW_ORIG_MSG_ID));
        setContentView(R.layout.pushpole_webview_layout);
        mWebView = (WebView) findViewById(R.id.pushpole_webview);
        if (PlainConstants.ACTION_SHOW_WEBVIEW.equals(getIntent().getAction())) {
            if(!isValidWebUrl(url)){
                url = "abcd";//a url which will bring 'page cannot be displayed' //TODO: @ak, check that if url is not available, it does nothing
            }
            try {
                mWebView.getSettings().setLoadsImagesAutomatically(true);
                mWebView.getSettings().setJavaScriptEnabled(true);
                mWebView.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
                mWebView.setWebViewClient(new PushPoleBrowser());
                mWebView.getSettings().setJavaScriptEnabled(true);
                mWebView.addJavascriptInterface(new WebViewJavaScriptInterface(this), "app");
                mWebView.loadUrl(url);

            }catch (Exception e){
                Logger.warning("Show Webview has error", new LogData("error", e.getMessage()));
            }
        }
    }

    private class PushPoleBrowser extends WebViewClient {
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            view.loadUrl(url);
            return true;
        }
    }

    private class WebViewJavaScriptInterface{

        private Context context;

        /*
         * Need a reference to the context in order to sent a post message
         */
        public WebViewJavaScriptInterface(Context context){
            this.context = context;
        }

        /*
         * This method can be called from Android. @JavascriptInterface
         * required after SDK version 17.
         */
        @JavascriptInterface
        public void sendResult(String formData){ //fprmData is a json
            Logger.debug("Data from javascript is : " + formData);
            String data = formData.substring(1, formData.length()-1); //removing enclosing bracket and \" from formData json
            Pack p = new Pack();
            if(data.contains(":")) {
                String [] str = data.split(":");
                p.putString(str[0].substring(1, str[0].length()-1), str[1].substring(1, str[1].length()-1));
            }
            p.putString(Constants.getVal(Constants.F_ORIGINAL_MESSAGE_ID), originalMsgId);
            p.putString(Constants.getVal(Constants.TIMESTAMP), String.valueOf(System.currentTimeMillis()));

            /*StringBuilder sb = new StringBuilder(data);
            sb.append(',').append(Constants.F_ORIGINAL_MESSAGE_ID).append(':').append(originalMsgId)
              .append(',').append(Constants.TIMESTAMP).append(':').append(String.valueOf(System.currentTimeMillis()));*/
            SendManager.getInstance(context).send(Constants.getVal(Constants.USER_INPUT_T), /*"{"+sb.toString()+"}"*/ p.toJson());

            WebviewActivity.this.finish(); //close webview activity
        }
    }
}
