package com.pushpole.sdk.action.actions;

import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.action.Action;
import com.pushpole.sdk.action.ActionFactory;
import com.pushpole.sdk.action.ActionType;
import com.pushpole.sdk.activities.WebviewActivity;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-07-04, 2:33 PM.
 * An Activity class to show a given url inside a webview
 * @author Akram Shokri
 */
public class WebViewAction extends Action{
    private String webUrl;
    private String originalMsgId;

    @Override
    public void execute(Context context) {
        Intent intent = new Intent(context, WebviewActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);

        intent.putExtra(Constants.getVal(Constants.WEBVIEW_URL), webUrl);
        intent.putExtra(Constants.getVal(Constants.WEBVIEW_ORIG_MSG_ID), originalMsgId);
        intent.setAction(PlainConstants.ACTION_SHOW_WEBVIEW);
        context.startActivity(intent);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.SHOW_IN_WEBVIEW;
    }

    /**
     * serialize to {@link Pack}
     *
     * @return
     */
    @Override
    public Pack toPack() {
        Pack pack = super.toPack();
        pack.putString(Constants.getVal(Constants.WEBVIEW_URL), webUrl);
        pack.putString(Constants.getVal(Constants.F_ORIGINAL_MESSAGE_ID), originalMsgId);
        return pack;
    }

    public static class Factory extends ActionFactory {

        @Override
        public Action buildAction(Pack data) {
            WebViewAction action = new WebViewAction();
            action.webUrl = data.getString(Constants.getVal(Constants.WEBVIEW_URL), "");
            action.originalMsgId = data.getString(Constants.getVal(Constants.F_ORIGINAL_MESSAGE_ID), "");
            return action;
        }
    }
}
