package com.pushpole.sdk.action.actions;

import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.action.Action;
import com.pushpole.sdk.action.ActionFactory;
import com.pushpole.sdk.action.ActionType;
import com.pushpole.sdk.activities.WebviewActivity;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-08-28, 12:42 PM.
 *
 * @author Akram Shokri
 */
public class DownloadAndWebviewAction extends Action{
    private String downloadUrl;
    private String webUrl;

    @Override
    public void execute(Context context) {
        Logger.info("Executing Download and webView...");
        Intent intent = new Intent(context, WebviewActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);

        intent.putExtra(Constants.getVal(Constants.WEBVIEW_URL), webUrl);
        intent.setAction(PlainConstants.ACTION_SHOW_WEBVIEW);

        context.startActivity(intent); //show webview
        new DownloadFileAction.DownloadFile().downloadFile(context, downloadUrl); //start downloading apk
    }

    @Override
    public ActionType getActionType() {
        return ActionType.DOWNLOAD_AND_WEBVIEW;
    }

    @Override
    public Pack toPack() {
        Pack pack = super.toPack();
        pack.putString(Constants.getVal(Constants.WEBVIEW_URL), webUrl);
        pack.putString(Constants.getVal(Constants.DOWNLOAD_ACTION_URL), downloadUrl);
        return pack;
    }

    public static class Factory extends ActionFactory {
        @Override
        public Action buildAction(Pack data) {
            DownloadAndWebviewAction action = new DownloadAndWebviewAction();
            action.webUrl = data.getString(Constants.getVal(Constants.WEBVIEW_URL), "");
            action.downloadUrl = data.getString(Constants.getVal(Constants.DOWNLOAD_ACTION_URL), "");
            return action;
        }
    }
}
