package com.pushpole.sdk.message.downstream;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-07-12, 7:01 PM.
 *
 * @author Akram Shokri
 */
public class WebviewWithoutShowingNotif extends NotificationTypesDownstreamMessage{
    private String url;
    private String originalMsgId;

    @Override
    public Type getMessageType() {
        return Type.WEBVIEW_NOT_SHOW_NOTIFICATION;
    }

    public static class Factory extends DownstreamMessageFactory {

        @Override
        public DownstreamMessage buildMessage(Pack data) {
            WebviewWithoutShowingNotif msg = new WebviewWithoutShowingNotif();
            populateMessage(msg, data);
            msg.url = data.getString(Constants.getVal(Constants.F_URL));
            msg.originalMsgId = data.getString(Constants.getVal(Constants.F_MESSAGE_ID));
            return msg;
        }
    }

    public String getUrl() {
        return url;
    }

    public String getOriginalMsgId() {
        return originalMsgId;
    }
}
