package com.pushpole.sdk.message.downstream;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-09-15, 11:16 AM.
 *
 * @author Akram Shokri
 */
public class UserSentryConfigMessage extends DownstreamMessage {
    private String userDsnUrl;
    private int userPercent; //between 0 and 100

    @Override
    public Type getMessageType() {
        return Type.CONFIG_USER_SENTRY;
    }

    public static class Factory extends DownstreamMessageFactory {
        @Override
        public DownstreamMessage buildMessage(Pack data) {
            Logger.debug("[Sentry] Building sentry message");
            UserSentryConfigMessage message = new UserSentryConfigMessage();
            message.userDsnUrl = data.getString(Constants.getVal(Constants.USER_DSN_URL), "");
            message.userPercent = data.getInt(Constants.getVal(Constants.USER_CRASH_REPORT_PERCENT), 100);
            if(message.userPercent > 100 || message.userPercent < 0)
                message.userPercent = 100;

            return message;
        }
    }

    public String getUserDsnUrl() {
        return userDsnUrl;
    }

    public int getUserPercent() {
        return userPercent;
    }

}
