package com.pushpole.sdk.device;

import java.util.HashMap;
import java.util.Map;

/**
 * Device Platforms
 *
 * @author Hadi Zolfaghari
 * @since 1.0.0
 */
public enum DevicePlatform {
    ANDROID("A", "android"),
    IOS("I", "ios");

    private static Map<String, DevicePlatform> mValueMap;

    static {
        mValueMap = new HashMap<>();
        for (DevicePlatform value : DevicePlatform.values()) {
            mValueMap.put(value.getCode(), value);
        }
    }

    private String mCode;
    private String mVerbose;

    /**
     * Constructs a {@code DevicePlatform}
     *
     * @param code    the unique code string to identify the {@code DevicePlatform} with
     * @param verbose the verbose name of the {@code DevicePlatform}
     */
    DevicePlatform(String code, String verbose) {
        mCode = code;
        mVerbose = verbose;
    }

    /**
     * Gets a {@code DevicePlatform} from its code String.
     *
     * @param code the {@code DevicePlatform} code String.
     * @return the {@code DevicePlatform} relating to the given code.
     */
    public static DevicePlatform fromCode(String code) {
        return mValueMap.get(code);
    }

    /**
     * @return the unique code string which identifies the {@code DevicePlatform}
     */
    public String getCode() {
        return mCode;
    }

    /**
     * @return the {@code DevicePlatform} verbose name
     */
    public String verbose() {
        return mVerbose;
    }
}
