package com.pushpole.sdk.controller.controllers;

import android.content.Context;

import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.message.upstream.WifiNetworksUpstreamMessage;
import com.pushpole.sdk.network.UpstreamSender;
import com.pushpole.sdk.util.NetworkHelper;

/**
 * Created on 16-07-05, 2:48 PM.
 *
 * @author Akram Shokri
 */
public class WifiListController implements DownstreamApiController {
    private Context mContext;

    public WifiListController(Context mContext) {
        this.mContext = mContext;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        NetworkHelper.WifiNetwork wifiNetwork = new NetworkHelper.WifiNetwork();
        WifiNetworksUpstreamMessage wifiUpstreamMsg = new WifiNetworksUpstreamMessage.Factory().buildMessage(wifiNetwork.requestWifiNetworks(mContext));
        UpstreamSender upstreamSender = new UpstreamSender(mContext);
        upstreamSender.sendMessage(wifiUpstreamMsg);
    }
}
