package com.pushpole.sdk.controller.controllers;

import android.content.Context;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.SenderInfo;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.task.PushPoleAsyncTask;
import com.pushpole.sdk.task.TaskManager;

/**
 * Created on 16-10-26, 1:15 PM.
 *
 * @author Akram Shokri
 */
public class DeleteTokenController implements DownstreamApiController {
    private Context mContext;

    public DeleteTokenController(Context context) {
        mContext = context;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        Logger.info("Delete token downstream request");
        SenderInfo.getInstance(mContext).setTokenState(mContext, 0);
        Logger.info("Command 23 executed and GCM Token removed, registering again");
        KeyStore.getInstance(mContext).putString(
                Constants.getVal(Constants.REGISTER_CAUSE), Constants.getVal(Constants.RegisterCause.REREGISTER_COMMAND)
        );

        //TODO:??? pushpole.initialize or just calling register??
        TaskManager.getInstance(mContext).asyncTask(new PushPoleAsyncTask() {
            @Override
            public void run(Context context) {
                new RegisterController(context).register();
            }
        });
    }
}
