package com.pushpole.sdk.controller.controllers;

import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.PlainConstants;
import com.pushpole.sdk.activities.RequestAccessDialogActivity;
import com.pushpole.sdk.controller.DownstreamApiController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.device.DeviceIDHelper;
import com.pushpole.sdk.message.downstream.AskUserPermissionMessage;
import com.pushpole.sdk.message.downstream.DownstreamMessage;
import com.pushpole.sdk.network.SendManager;
import com.pushpole.sdk.util.Pack;
import com.pushpole.sdk.util.PermissionChecker;

/**
 * Created on 2017-07-08, 2:02 PM.
 *
 * @author Akram Shokri
 */

public class AskUserPermissionController implements DownstreamApiController {
    private Context mContext;

    public AskUserPermissionController(Context context) {
        mContext = context;
    }

    @Override
    public void handleDownstreamMessage(DownstreamMessage message) {
        AskUserPermissionMessage dialogMsg = (AskUserPermissionMessage) message;
        if(dialogMsg.isSetGetImeiOff()){
            KeyStore.getInstance(mContext).putInt(
                    PlainConstants.KEY_STORE_USE_IMEI_USER_ANSWER, 0 /*zero means user declined permission*/);
            return; //in this case that a command is sent to make 'ImeiAccessState' to 'declined',
            // nothing more is needed to be done.
        }

        if (PermissionChecker.hasPermission(mContext, PermissionChecker.READ_PHONE_STATE)) {
            int prevPrivacyVersion = KeyStore.getInstance(mContext).getInt(
                    Constants.getVal(Constants.KEY_STORE_ASK_IMEI_PRIVACY_VERSION), -1);
            //If user previously seen this dialog, don't show it again unless it is has `showAnyway`
            //attribute or this is contains newer version of privacy policy terms
            if (   (!DeviceIDHelper.imeiAccessRefused(mContext)
                    && !DeviceIDHelper.imeiAccessGranted(mContext))
                    || dialogMsg.isShowAnyway() || (dialogMsg.getTermsVersion() > prevPrivacyVersion)
               ) {

                Intent intent = new Intent(mContext, RequestAccessDialogActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);

                intent.putExtra(Constants.getVal(Constants.ASK_IMEI_DIALOG_CONTENT), dialogMsg.getPrivacyMsg());
                intent.putExtra(Constants.getVal(Constants.ASK_IMEI_DIALOG_TITLE), dialogMsg.getPrivacyTitle());
                if (dialogMsg.getDialogIcon() != null && !dialogMsg.getDialogIcon().isEmpty()) {
                    intent.putExtra(Constants.getVal(Constants.ASK_IMEI_DIALOG_ICON), dialogMsg.getDialogIcon());
                }
                if(dialogMsg.getOkBtnTxt() != null && ! dialogMsg.getOkBtnTxt().isEmpty()){
                    intent.putExtra(Constants.getVal(Constants.ASK_IMEI_PRIVACY_OK_BTN_TXT), dialogMsg.getOkBtnTxt());
                }
                if(dialogMsg.getCancelBtnTxt() != null && ! dialogMsg.getCancelBtnTxt().isEmpty()){
                    intent.putExtra(Constants.getVal(Constants.ASK_IMEI_PRIVACY_CANCEL_BTN_TXT), dialogMsg.getCancelBtnTxt());
                }
                KeyStore.getInstance(mContext).putInt(Constants.getVal(Constants.KEY_STORE_ASK_IMEI_PRIVACY_VERSION),
                        dialogMsg.getTermsVersion());
                mContext.startActivity(intent);
            }
        } else {
            //TODO: send no_permission in upstream
            Pack p = new Pack();
            p.putString(Constants.getVal(Constants.USE_IMEI_STATE), Constants.getVal(Constants.USE_IMEI_STATE_NO_PERMISSION));
            SendManager.getInstance(mContext).send(Constants.getVal(Constants.ASK_IMEI_PERMISSION_T), p);
        }

    }
}
