package com.pushpole.sdk.collection.tasks;

import android.content.Context;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.controller.controllers.ConstantDeviceDataController;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.LogData;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.options.DefaultOptions;
import com.pushpole.sdk.task.options.SingletonTask;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-07-24, 11:42 AM.
 *
 * @author Akram Shokri
 * Getting constant device data
 */

@SingletonTask
@DefaultOptions(period = 30 * 24 * 60 * 60 * 1000L) //default schedule: 2 days
public class ConstantTask extends CollectionTask {

    @Override
    public Result runTask(Context context, Pack taskData) {
        Logger.info("Running constant data task");
        if (taskData == null || !taskData.getBool("force")) {
            Long collectionPeriod = KeyStore.getInstance(context).getLong("collection_period_t3", 30 * 24 * 60 * 60 * 1000L);
            Long lastCollectionTime = KeyStore.getInstance(context).getLong("last_collection_t3", 0);

            if (collectionPeriod == -1) {
                Logger.warning("Skipping const data collection, the collection has been cancelled and should not run");
                return Result.SUCCESS;
            } else {
                Long now = System.currentTimeMillis();
                if (lastCollectionTime > 0 && now > lastCollectionTime && (now - lastCollectionTime) < collectionPeriod) {
                    Logger.warning("Skipping const data collection since it has already been run in this interval", new LogData(
                            "Last Run", String.valueOf(lastCollectionTime),
                            "Now", String.valueOf(now),
                            "Period", String.valueOf(collectionPeriod)
                    ));
                    return Result.SUCCESS;
                }
                KeyStore.getInstance(context).putLong("last_collection_t3", now);
            }
        }

        Pack constantData = new ConstantDeviceDataController(context).getConstantData();
        this.processResult(context, constantData, Constants.getVal(Constants.CONSTANT_DATA_T));
        return Result.SUCCESS;
    }
}
